/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.defaults;

import com.steammachine.jsonchecker.defaults.DefaultWidgetNode;
import com.steammachine.jsonchecker.types.Identity;
import com.steammachine.jsonchecker.types.NodeCheckContext;
import com.steammachine.jsonchecker.types.NodeChecker;
import com.steammachine.jsonchecker.types.SqNodeKeyType;
import com.steammachine.jsonchecker.types.UnmappedProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DefaultWidgetNodeChecker
implements UnmappedProperties,
Identity<SqNodeKeyType>,
NodeChecker<DefaultWidgetNode> {
    private static final List<Items> DEFAULT_ITEMS = Arrays.asList(Items.value, Items.visible);
    private Set<Items> items = new HashSet<Items>(DEFAULT_ITEMS);
    private String monkeyId;
    private String componentType;
    private boolean visible;
    private String className;
    private String type;
    private String value;
    private final Map<String, String> unmapped = new HashMap<String, String>();

    public void setValue(String value) {
        this.value = value;
    }

    public void setMonkeyId(String monkeyId) {
        this.monkeyId = monkeyId;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String value() {
        return this.value;
    }

    public String monkeyId() {
        return this.monkeyId;
    }

    public String componentType() {
        return this.componentType;
    }

    public boolean visible() {
        return this.visible;
    }

    public String className() {
        return this.className;
    }

    public String type() {
        return this.type;
    }

    @Override
    public boolean checks(Class type) {
        return DefaultWidgetNode.class.isAssignableFrom(type);
    }

    @Override
    public void check(DefaultWidgetNode widgetNode, String path, NodeCheckContext context) {
        DefaultWidgetNodeChecker.check(widgetNode, path, context, this);
    }

    @Override
    public void setValue(String propertyName, String value) {
        this.unmapped.put(propertyName, value);
    }

    public String toString() {
        return "DefaultWidgetNodeChecker{items=" + this.items + ", monkeyId='" + this.monkeyId + '\'' + ", componentType='" + this.componentType + '\'' + ", visible=" + this.visible + ", className='" + this.className + '\'' + ", type='" + this.type + '\'' + ", value='" + this.value + '\'' + ", unmapped=" + this.unmapped + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultWidgetNodeChecker)) {
            return false;
        }
        DefaultWidgetNodeChecker that = (DefaultWidgetNodeChecker)o;
        if (this.visible != that.visible) {
            return false;
        }
        if (this.monkeyId != null ? !this.monkeyId.equals(that.monkeyId) : that.monkeyId != null) {
            return false;
        }
        if (this.componentType != null ? !this.componentType.equals(that.componentType) : that.componentType != null) {
            return false;
        }
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.unmapped.equals(that.unmapped);
    }

    public int hashCode() {
        int result = this.monkeyId != null ? this.monkeyId.hashCode() : 0;
        result = 31 * result + (this.componentType != null ? this.componentType.hashCode() : 0);
        result = 31 * result + (this.visible ? 1 : 0);
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + this.unmapped.hashCode();
        return result;
    }

    @Override
    public boolean supports(Class<?> identityType) {
        return SqNodeKeyType.class.isAssignableFrom(identityType);
    }

    @Override
    public String ident(SqNodeKeyType identityType) {
        switch (identityType) {
            case monkeyId: {
                return this.monkeyId;
            }
            case componentType: {
                return this.componentType;
            }
        }
        throw new IllegalStateException("unknown identity type " + (Object)((Object)identityType));
    }

    private static void check(DefaultWidgetNode widgetNode, String path, NodeCheckContext context, DefaultWidgetNodeChecker checker) {
        if (checker.visible() != widgetNode.visible()) {
            context.log("element by path '", path, "'  has wrong value of 'visible' actual(", widgetNode.visible(), ") expected(", checker.visible(), ")");
            context.failed();
        }
        if (!Objects.equals(checker.monkeyId(), widgetNode.monkeyId())) {
            context.log("element by path '", path, "'  has wrong value of 'monkeyId' actual(", widgetNode.monkeyId() + ") expected(", checker.monkeyId(), ")");
            context.failed();
        }
        if (!Objects.equals(checker.componentType(), widgetNode.componentType())) {
            context.log("element by path '", path, "'  has wrong value of 'componentType' actual(", widgetNode.componentType(), ") expected(", checker.componentType(), ")");
            context.failed();
        }
        if (!Objects.equals(checker.className(), widgetNode.className())) {
            context.log("element by path '", path, "'  has wrong value of 'className' actual(", widgetNode.className(), ") expected(", checker.className(), ")");
            context.failed();
        }
        if (!Objects.equals(checker.type(), widgetNode.type())) {
            context.log("element by path '", path, "'  has wrong value of 'type' actual(", widgetNode.type(), ") expected(", checker.type(), ")");
            context.failed();
        }
        if (!Objects.equals(checker.value(), widgetNode.value())) {
            context.log("element by path '", path, "'  has wrong value of 'value' actual(", widgetNode.value(), ") expected(", checker.value(), ")");
            context.failed();
        }
    }

    public static enum Items {
        visible,
        value;

    }
}

