package com.steammachine.org.properties.plugin
/**
 * Created by Vladimir Bogodukhov on 16.12.2017.
 *
 * @author Vladimir Bogodukhov
 *
 * {@link com.steammachine.org.properties.plugin.PropertySet}
 *        com.steammachine.org.properties.plugin.PropertySet
 *
 */
class PropertySet {

    final Map<String, String> items = [:]

    /**
     *
     * Adds property file content
     * @param - files
     */
    void setPropertyFiles(File... files) {
        files.each {
            new FileInputStream(it).withCloseable {
                def properties = new Properties()
                properties.load(it)
                properties.each { prop -> items.put(prop.key as String, prop.value as String) }
            }
        }
    }

    /**
     *
     * Adds property file content
     * @param - files
     */
    void setPropertyFile(File file) {
        setPropertyFiles(file)
    }

    def propertyMissing(String name) {
        items[name]
    }

}
