/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.commonutils.orderedproperties;

import com.steammachine.common.utils.commonutils.CommonUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;

public class OrderedProperties {
    private static final char EQUALSIGN = '=';
    private static final char SPACESIGN = ' ';
    private static final String STRING_PLACEHOLDER = "%s";
    private static final String PREFIX = "PREFIX";
    private static final Function<Character, Boolean> SPACE = c -> c.charValue() == ' ';
    private static final Function<Character, Boolean> EQUAL = c -> c.charValue() == '=';
    private static final Function<Character, Boolean> SPACE_OR_EQUALS = c -> c.charValue() == ' ' || c.charValue() == '=';
    private static final Function<Character, Boolean> WRITTEN_VALUE = c -> !Character.isSpaceChar(c.charValue());
    private final LinkedHashMap<Key, Item> properties = new LinkedHashMap();
    private int currentPrefix;

    public void load(InputStream stream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.lines().peek(Objects::requireNonNull).map(OrderedProperties::parseValue).forEachOrdered(v -> this.properties.put(this.newKey(((Item)v).itemType, ((Item)v).key), (Item)v));
    }

    public void store(OutputStream stream) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
        this.properties.entrySet().stream().map(Map.Entry::getValue).map(OrderedProperties::getLine).forEachOrdered(s -> {
            CommonUtils.suppressWOResult(() -> writer.write((String)s));
            CommonUtils.suppressWOResult(writer::newLine);
        });
        writer.flush();
    }

    public void clear() {
        this.properties.clear();
        this.currentPrefix = 0;
    }

    public void setProperty(String key, String value) {
        Key keyy = new Key(ItemType.VALUE, key);
        this.properties.computeIfAbsent(keyy, key1 -> Item.value("%s=%s", ((Key)key1).id, null)).value = value;
    }

    public String getProperty(String key) {
        Item item = this.properties.get(new Key(ItemType.VALUE, key));
        return item == null ? null : item.value;
    }

    public Properties toProperties() {
        Properties props = new Properties();
        this.properties.entrySet().stream().filter(entry -> ((Key)entry.getKey()).type == ItemType.VALUE).forEachOrdered(i -> props.setProperty(((Key)i.getKey()).id, ((Item)i.getValue()).value));
        return props;
    }

    static Item parseValue(String data) {
        Objects.requireNonNull(data);
        if (data.trim().isEmpty()) {
            return new Item(ItemType.NOT_FILLED, data, "", "");
        }
        if (data.trim().startsWith("#")) {
            return new Item(ItemType.COMMENT, data, "", "");
        }
        StringBuilder template = new StringBuilder();
        int keyFirst = Objects.requireNonNull(OrderedProperties.findFirst(data, 0, WRITTEN_VALUE));
        Integer keyLast = OrderedProperties.findFirst(data, keyFirst + 1, SPACE_OR_EQUALS);
        String key = keyLast != null ? data.substring(keyFirst, keyLast) : data.substring(keyFirst);
        template.append(data.substring(0, keyFirst));
        template.append(STRING_PLACEHOLDER);
        if (keyLast == null) {
            template.append(STRING_PLACEHOLDER);
            return new Item(ItemType.VALUE, template.toString(), key, "");
        }
        int dividerFirst = Objects.requireNonNull(OrderedProperties.findFirst(data, keyLast, SPACE_OR_EQUALS));
        template.append(data.substring(keyLast, dividerFirst));
        Integer spaceFirst = OrderedProperties.findFirst(data, keyFirst + 1, SPACE);
        Integer equalsFirst = OrderedProperties.findFirst(data, keyFirst + 1, EQUAL);
        if (spaceFirst == null && equalsFirst != null) {
            int dividerLast = dividerFirst + 1;
            template.append('=');
            String rest = data.substring(dividerLast);
            int valueFirst = Objects.requireNonNull(OrderedProperties.findFirst(rest, 0, WRITTEN_VALUE));
            String value = rest.substring(valueFirst);
            template.append(rest.substring(0, valueFirst));
            template.append(STRING_PLACEHOLDER);
            return new Item(ItemType.VALUE, template.toString(), key, value);
        }
        if (spaceFirst != null && equalsFirst == null) {
            int valueFirst = Objects.requireNonNull(OrderedProperties.findFirst(data, spaceFirst + 1, WRITTEN_VALUE));
            template.append(data.substring(keyLast, valueFirst));
            template.append(STRING_PLACEHOLDER);
            String value = data.substring(valueFirst);
            return new Item(ItemType.VALUE, template.toString(), key, value);
        }
        Objects.requireNonNull(spaceFirst);
        Objects.requireNonNull(equalsFirst);
        CommonUtils.check(() -> !Objects.equals(spaceFirst, equalsFirst), IllegalStateException::new);
        if (spaceFirst > equalsFirst) {
            template.append(data.substring(keyLast, equalsFirst));
            template.append('=');
            String rest = data.substring(equalsFirst + 1);
            Integer firstValueIndex = OrderedProperties.findFirst(rest, 0, WRITTEN_VALUE);
            template.append(rest.substring(0, firstValueIndex));
            template.append(STRING_PLACEHOLDER);
            String value = rest.substring(firstValueIndex);
            return Item.value("" + template, key, value);
        }
        if (spaceFirst < equalsFirst) {
            int valueFirst = Objects.requireNonNull(OrderedProperties.findFirst(data, spaceFirst + 1, WRITTEN_VALUE));
            if (valueFirst < equalsFirst) {
                template.append(data.substring(keyLast, valueFirst));
                template.append(STRING_PLACEHOLDER);
                String value = data.substring(valueFirst);
                return Item.value("" + template, key, value);
            }
            template.append(data.substring(keyLast, equalsFirst));
            template.append('=');
            valueFirst = Objects.requireNonNull(OrderedProperties.findFirst(data, equalsFirst + 1, WRITTEN_VALUE));
            template.append(data.substring(equalsFirst + 1, valueFirst));
            template.append(STRING_PLACEHOLDER);
            String value = data.substring(valueFirst);
            return Item.value("" + template, key, value);
        }
        throw new IllegalStateException();
    }

    static String getLine(Item item) {
        Objects.requireNonNull(item);
        switch (item.itemType) {
            case NOT_FILLED: 
            case COMMENT: {
                return item.template;
            }
            case VALUE: {
                return String.format(item.template, item.key, item.value);
            }
        }
        throw new IllegalStateException(String.format("unknown itemtype %s ", "" + item.itemType.name()));
    }

    private Key newKey(ItemType itemType, String id) {
        switch (itemType) {
            case NOT_FILLED: 
            case COMMENT: {
                return this.uniqueId(itemType);
            }
            case VALUE: {
                return new Key(itemType, id);
            }
        }
        throw new IllegalStateException(String.format("unknown type %s", itemType.name()));
    }

    private Key uniqueId(ItemType itemType) {
        CommonUtils.check(() -> itemType == ItemType.COMMENT || itemType == ItemType.NOT_FILLED, IllegalStateException::new);
        while (this.properties.keySet().contains(new Key(itemType, PREFIX + this.currentPrefix))) {
            ++this.currentPrefix;
        }
        return new Key(itemType, PREFIX + this.currentPrefix);
    }

    private static Integer findFirst(String data, int start, Function<Character, Boolean> function) {
        for (int i = start; i < data.length(); ++i) {
            if (!function.apply(Character.valueOf(data.charAt(i))).booleanValue()) continue;
            return i;
        }
        return null;
    }

    static class Item {
        private final ItemType itemType;
        private final String template;
        private final String key;
        private String value;

        Item(ItemType itemType, String template, String key, String value) {
            this.itemType = Objects.requireNonNull(itemType);
            this.template = Objects.requireNonNull(template);
            this.key = key;
            this.value = value;
        }

        static Item notFilled(String data) {
            return new Item(ItemType.NOT_FILLED, data, null, null);
        }

        static Item comment(String comment) {
            return new Item(ItemType.COMMENT, comment, null, null);
        }

        static Item value(String template, String key, String value) {
            return new Item(ItemType.VALUE, template, key, value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            if (this.itemType != item.itemType) {
                return false;
            }
            if (this.template != null ? !this.template.equals(item.template) : item.template != null) {
                return false;
            }
            if (this.key != null ? !this.key.equals(item.key) : item.key != null) {
                return false;
            }
            return this.value != null ? this.value.equals(item.value) : item.value == null;
        }

        public int hashCode() {
            int result = this.itemType != null ? this.itemType.hashCode() : 0;
            result = 31 * result + (this.template != null ? this.template.hashCode() : 0);
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Item{itemType=" + (Object)((Object)this.itemType) + ", template='" + this.template + '\'' + ", id='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    static class Key {
        private final ItemType type;
        private final String id;

        Key(ItemType type, String id) {
            this.type = Objects.requireNonNull(type);
            this.id = Objects.requireNonNull(id);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key1 = (Key)o;
            if (this.type != key1.type) {
                return false;
            }
            return this.id != null ? this.id.equals(key1.id) : key1.id == null;
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Key{type=" + (Object)((Object)this.type) + ", id='" + this.id + '\'' + '}';
        }
    }

    static enum ItemType {
        NOT_FILLED,
        COMMENT,
        VALUE;

    }
}

