/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.common.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class ListBuilder<T> {
    private final List<T> list = new ArrayList<T>();

    private ListBuilder() {
    }

    public static <T> ListBuilder<T> of() {
        return new ListBuilder<T>();
    }

    public final ListBuilder<T> clear() {
        this.list.clear();
        return this;
    }

    @SafeVarargs
    public final ListBuilder<T> add(T ... t) {
        this.list.addAll(Arrays.asList(t));
        return this;
    }

    public final ListBuilder<T> conf(Consumer<ListBuilder<T>> consumer) {
        consumer.accept(this);
        return this;
    }

    @SafeVarargs
    public final ListBuilder<T> addList(List<T> ... lists) {
        Stream.of(lists).forEachOrdered(this.list::addAll);
        return this;
    }

    public ListBuilder<T> merge(ListBuilder<T> builder) {
        if (this != builder) {
            this.list.addAll(builder.list);
        }
        return this;
    }

    public List<T> unmodifiedList() {
        return Collections.unmodifiableList(this.list);
    }
}

