/*
 * Decompiled with CFR 0.152.
 */
package org.builtzwilnerapi.game;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.bson.Document;
import org.builtzwilnerapi.db.json.AJsonBson;
import org.builtzwilnerapi.game.cell.ACellContent;
import org.builtzwilnerapi.game.cell.CellContentEmpty;
import org.builtzwilnerapi.game.cell.CellContentHit;
import org.builtzwilnerapi.game.cell.CellContentMiss;
import org.builtzwilnerapi.game.cell.CellContentShip;
import org.builtzwilnerapi.view.IHasView;

public class Cell
extends AJsonBson<Cell>
implements IHasView {
    ACellContent content;

    public Cell() {
        this.content = new CellContentEmpty();
    }

    public Cell(ACellContent content) {
        this.content = content;
    }

    public void setContent(ACellContent content) {
        this.content = content;
    }

    @Override
    public Document toBson() {
        Document enc = new Document();
        enc.put("content", (Object)this.content.toBson());
        return enc;
    }

    @Override
    public JsonObject toJson() {
        JsonObject enc = new JsonObject();
        enc.add("content", (JsonElement)this.content.toJson());
        return enc;
    }

    @Override
    public void doFromJson(JsonObject dec) {
        JsonObject decContent = dec.get("content").getAsJsonObject();
        String decContentValue = decContent.get("value").getAsString();
        if (decContentValue.equals("empty")) {
            this.content = new CellContentEmpty();
        } else if (decContentValue.equals("hit")) {
            this.content = new CellContentHit();
        } else if (decContentValue.equals("miss")) {
            this.content = new CellContentMiss();
        } else if (decContentValue.startsWith("ship")) {
            this.content = new CellContentShip();
        }
    }

    @Override
    public void doFromBson(Document dec) {
        Document decContent = (Document)dec.get((Object)"content");
        String decContentValue = (String)decContent.get((Object)"value");
        if (decContentValue.equals("empty")) {
            this.content = new CellContentEmpty();
        } else if (decContentValue.equals("hit")) {
            this.content = new CellContentHit();
        } else if (decContentValue.equals("miss")) {
            this.content = new CellContentMiss();
        } else if (decContentValue.startsWith("ship")) {
            this.content = new CellContentShip();
        }
    }

    public ACellContent getContent() {
        return this.content;
    }
}

