/*
 * Decompiled with CFR 0.152.
 */
package org.testgame.tests;

import com.google.gson.JsonParser;
import org.builtzwilnerapi.game.Field;
import org.builtzwilnerapi.user.UserToken;
import org.testgame.commands.CreateGameCommand;
import org.testgame.commands.game.GameStatusCommand;
import org.testgame.commands.game.PlaceShipsCommand;
import org.testgame.game.GameConnector;
import org.testgame.game.ServerResponseHandler;
import org.testgame.tests.FieldChecker;

public class Test_004 {
    boolean testIsPassed = true;

    public static void main(String[] args) {
        UserToken clientToken = new UserToken("62e83b31-a236-442f-bdac-4c1fc11747d6");
        UserToken serverToken = new UserToken("ai-default");
        String baseUrl = "http://localhost:8765";
        Test_004 test = new Test_004();
        test.test(clientToken, serverToken, baseUrl);
    }

    public boolean test(UserToken clientToken, UserToken serverToken, String baseUrl) {
        try {
            CreateGameCommand createGameCommand = new CreateGameCommand(clientToken, serverToken);
            GameConnector gameConnector = new GameConnector();
            String responseCreateGame = gameConnector.sendGet(baseUrl + createGameCommand.getUrlCreateGame(), clientToken);
            String gameId = new JsonParser().parse(responseCreateGame).getAsJsonObject().get("data").getAsJsonObject().get("game_id").getAsString();
            Field field = new Field();
            field.randFillTenCells();
            PlaceShipsCommand placeShipsCommand = new PlaceShipsCommand(clientToken, gameId, field);
            System.out.println("placeShipsCommand:  " + placeShipsCommand.getUrlPlaceShips());
            gameConnector.sendGet(baseUrl + placeShipsCommand.getUrlPlaceShips(), clientToken);
            String responseGameStatus = Test_004.getGameStatus(gameId, gameConnector, clientToken, baseUrl);
            ServerResponseHandler serverResponseHandler = new ServerResponseHandler();
            Field fieldFromServer = serverResponseHandler.createFieldFromResponse(responseGameStatus, serverToken, gameId);
            FieldChecker fieldChecker = new FieldChecker();
            this.testIsPassed = fieldChecker.checkField(fieldFromServer);
            System.out.println("---");
            fieldFromServer.printField();
            System.out.println("---");
            System.out.println("the tests is " + this.testIsPassed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.testIsPassed;
    }

    private static String getGameStatus(String gameId, GameConnector gameConnector, UserToken clientToken, String baseUrl) throws Exception {
        GameStatusCommand gameStatusCommand = new GameStatusCommand(clientToken, gameId);
        return gameConnector.sendGet(baseUrl + gameStatusCommand.getUrlStatusGame(), clientToken);
    }
}

