/*
 * Decompiled with CFR 0.152.
 */
package org.testgame.tests;

import com.google.gson.JsonParser;
import org.builtzwilnerapi.game.Field;
import org.builtzwilnerapi.user.UserToken;
import org.testgame.commands.CreateGameCommand;
import org.testgame.commands.game.GameStatusCommand;
import org.testgame.commands.game.PlaceShipsCommand;
import org.testgame.commands.game.ShootCommand;
import org.testgame.commands.game.StartCommand;
import org.testgame.game.GameConnector;
import org.testgame.game.ServerResponseHandler;

public class Test_003 {
    boolean testIsPassed = true;

    public static void main(String[] args) {
        UserToken clientToken = new UserToken("62e83b31-a236-442f-bdac-4c1fc11747d6");
        UserToken serverToken = new UserToken("ai-default");
        String baseUrl = "http://localhost:8765";
        Test_003 test = new Test_003();
        test.test(clientToken, serverToken, baseUrl);
    }

    public boolean test(UserToken clientToken, UserToken serverToken, String baseUrl) {
        try {
            CreateGameCommand createGameCommand = new CreateGameCommand(clientToken, serverToken);
            GameConnector gameConnector = new GameConnector();
            String responseCreateGame = gameConnector.sendGet(baseUrl + createGameCommand.getUrlCreateGame(), clientToken);
            String gameId = new JsonParser().parse(responseCreateGame).getAsJsonObject().get("data").getAsJsonObject().get("game_id").getAsString();
            Field field = new Field();
            field.randFillTenCells();
            System.out.println("\n*** User field was created ***\n");
            field.printField();
            PlaceShipsCommand placeShipsCommand = new PlaceShipsCommand(clientToken, gameId, field);
            System.out.println("placeShipsCommand:  " + placeShipsCommand.getUrlPlaceShips());
            gameConnector.sendGet(baseUrl + placeShipsCommand.getUrlPlaceShips(), clientToken);
            StartCommand startCommand = new StartCommand(clientToken, gameId);
            gameConnector.sendGet(baseUrl + startCommand.getUrlPlaceShips(), clientToken);
            ServerResponseHandler serverResponseHandler = new ServerResponseHandler();
            Field oldFieldFromUser = new Field();
            Field oldFieldFromServer = new Field();
            Field fieldFromUser = null;
            for (int y = 0; y < 10; ++y) {
                String responseGameStatus;
                boolean gameIsNotFinished;
                for (int x = 0; x < 10 && (gameIsNotFinished = serverResponseHandler.getStatusRunFinished(responseGameStatus = Test_003.getGameStatus(gameId, gameConnector, clientToken, baseUrl), gameId)); ++x) {
                    ShootCommand shootCommand = new ShootCommand(clientToken, gameId, x, y);
                    String responseShoot = gameConnector.sendGet(baseUrl + shootCommand.getUrlSoot(), clientToken);
                    System.out.println("responseShoot:   " + responseShoot);
                    String finalyResponseGameStatus = Test_003.getGameStatus(gameId, gameConnector, clientToken, baseUrl);
                    fieldFromUser = serverResponseHandler.createFieldFromResponse(finalyResponseGameStatus, clientToken, gameId);
                    Field fieldFromServer = serverResponseHandler.createFieldFromResponse(finalyResponseGameStatus, serverToken, gameId);
                    if (!oldFieldFromUser.checkThatFieldIsEmpty()) {
                        boolean status = oldFieldFromUser.compareFild(oldFieldFromUser, fieldFromUser);
                        if (status) {
                            this.testIsPassed = false;
                            System.out.println("============================= FAIL: The server don't made move! =============================");
                        } else {
                            System.out.println("============================= OK: The server made move! =============================");
                        }
                    }
                    System.out.println("\n*** new field from user ***\n");
                    fieldFromUser.printField();
                    System.out.println("\n*** old field from user ***\n");
                    oldFieldFromUser.printField();
                    System.out.println("\n*** new field from server ***\n");
                    fieldFromServer.printField();
                    System.out.println("\n*** old field from server ***\n");
                    oldFieldFromServer.printField();
                    oldFieldFromUser = fieldFromUser;
                    oldFieldFromServer = fieldFromServer;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Test result is " + this.testIsPassed);
        return this.testIsPassed;
    }

    private static String getGameStatus(String gameId, GameConnector gameConnector, UserToken token, String baseUrl) throws Exception {
        GameStatusCommand gameStatusCommand = new GameStatusCommand(token, gameId);
        return gameConnector.sendGet(baseUrl + gameStatusCommand.getUrlStatusGame(), token);
    }
}

