/*
 * Decompiled with CFR 0.152.
 */
package org.testgame.tests;

import com.google.gson.JsonParser;
import org.builtzwilnerapi.game.Field;
import org.builtzwilnerapi.user.UserToken;
import org.testgame.commands.CreateGameCommand;
import org.testgame.commands.game.GameStatusCommand;
import org.testgame.commands.game.PlaceShipsCommand;
import org.testgame.commands.game.ShootCommand;
import org.testgame.commands.game.StartCommand;
import org.testgame.game.GameConnector;
import org.testgame.game.ServerResponseHandler;

public class Test_002 {
    boolean testIsPassed = true;

    public static void main(String[] args) {
        UserToken clientToken = new UserToken("62e83b31-a236-442f-bdac-4c1fc11747d6");
        UserToken serverToken = new UserToken("ai-default");
        String baseUrl = "http://localhost:8765";
        Test_002 test = new Test_002();
        test.test(clientToken, serverToken, baseUrl);
    }

    public boolean test(UserToken clientToken, UserToken serverToken, String baseUrl) {
        try {
            CreateGameCommand createGameCommand = new CreateGameCommand(clientToken, serverToken);
            GameConnector gameConnector = new GameConnector();
            String responseCreateGame = gameConnector.sendGet(baseUrl + createGameCommand.getUrlCreateGame(), clientToken);
            String gameId = new JsonParser().parse(responseCreateGame).getAsJsonObject().get("data").getAsJsonObject().get("game_id").getAsString();
            Field field = new Field();
            field.randFillTenCells();
            PlaceShipsCommand placeShipsCommand = new PlaceShipsCommand(clientToken, gameId, field);
            System.out.println("placeShipsCommand:  " + placeShipsCommand.getUrlPlaceShips());
            gameConnector.sendGet(baseUrl + placeShipsCommand.getUrlPlaceShips(), clientToken);
            StartCommand startCommand = new StartCommand(clientToken, gameId);
            gameConnector.sendGet(baseUrl + startCommand.getUrlPlaceShips(), clientToken);
            ServerResponseHandler serverResponseHandler = new ServerResponseHandler();
            Field oldServerField = new Field();
            boolean gameIsNotFinished = true;
            boolean status = true;
            block4: for (int y = 0; y < 10; ++y) {
                for (int x = 0; x < 10; ++x) {
                    Field finalyFieldFromServer = null;
                    try {
                        String responseGameStatus = Test_002.getGameStatus(gameId, gameConnector, clientToken, baseUrl);
                        gameIsNotFinished = serverResponseHandler.getStatusRunFinished(responseGameStatus, gameId);
                        if (!gameIsNotFinished) continue block4;
                        ShootCommand shootCommand = new ShootCommand(clientToken, gameId, x, y);
                        String responseShoot = gameConnector.sendGet(baseUrl + shootCommand.getUrlSoot(), clientToken);
                        System.out.println("responseShoot:   " + responseShoot);
                        String finalyResponseGameStatus = Test_002.getGameStatus(gameId, gameConnector, clientToken, baseUrl);
                        finalyFieldFromServer = serverResponseHandler.createFieldFromResponse(finalyResponseGameStatus, serverToken, gameId);
                        String cellStatus = finalyFieldFromServer.getCell(x, y).getContent().getValue();
                        if (!oldServerField.checkThatFieldIsEmpty()) {
                            status = oldServerField.compareFildExcludeOneCell(oldServerField, finalyFieldFromServer, x, y);
                            if (status & (cellStatus.equals("miss") | cellStatus.equals("hit"))) {
                                System.out.println("!!! \u041e\u041a =============================");
                            } else {
                                this.testIsPassed = false;
                                System.out.println("x = " + x + " y = " + y);
                            }
                        }
                        System.out.println("\n*** old Field from server ***\n");
                        oldServerField.printField();
                        System.out.println("\n*** new Field from server ***\n");
                        finalyFieldFromServer.printField();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    oldServerField = finalyFieldFromServer;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Test result is " + this.testIsPassed);
        return this.testIsPassed;
    }

    private static String getGameStatus(String gameId, GameConnector gameConnector, UserToken clientToken, String baseUrl) throws Exception {
        GameStatusCommand gameStatusCommand = new GameStatusCommand(clientToken, gameId);
        return gameConnector.sendGet(baseUrl + gameStatusCommand.getUrlStatusGame(), clientToken);
    }
}

