/*
 * Decompiled with CFR 0.152.
 */
package org.testgame.tests;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.function.BiConsumer;
import org.builtzwilnerapi.game.Field;
import org.builtzwilnerapi.game.GameID;
import org.builtzwilnerapi.game.cell.CellContentShot;
import org.builtzwilnerapi.game.status.AGameStatus;
import org.builtzwilnerapi.game.status.GameStatusDoesNotExist;
import org.builtzwilnerapi.game.status.GameStatusFinished;
import org.builtzwilnerapi.game.status.GameStatusNew;
import org.builtzwilnerapi.game.status.GameStatusRunning;
import org.builtzwilnerapi.user.UserToken;
import org.testgame.commands.CreateGameCommand;
import org.testgame.commands.game.GameStatusCommand;
import org.testgame.commands.game.PlaceShipsCommand;
import org.testgame.commands.game.ShootCommand;
import org.testgame.commands.game.StartCommand;
import org.testgame.game.Actions;
import org.testgame.game.GameConnector;

public class Main {
    private static GameStatusCommand gameStatusCommand = null;
    private static String responseGameStatus;
    private static String gameId;
    private static String baseUrl;

    public static void main(String[] args) throws Exception {
        UserToken clientToken = new UserToken("36e9f527-12a3-407c-9f78-1b33e88f230a");
        UserToken serverToken = new UserToken("ai-default");
        CreateGameCommand createGameCommand = new CreateGameCommand(clientToken, serverToken);
        GameConnector gameConnector = new GameConnector();
        String responseCreateGame = gameConnector.sendGet(baseUrl + createGameCommand.getUrlCreateGame(), clientToken);
        BiConsumer<Integer, Integer> shoter = (x, y) -> {
            try {
                ShootCommand shootCommand = new ShootCommand(clientToken, gameId, (int)x, (int)y);
                String responseShoot = gameConnector.sendGet(baseUrl + shootCommand.getUrlSoot(), clientToken);
                System.out.println("responseShoot:   " + responseShoot);
                responseGameStatus = Main.getGameStatus(gameId, gameConnector, clientToken);
                Main.showField(responseGameStatus, clientToken, serverToken);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        Actions actions = new Actions();
        actions.shooter(shoter);
        gameId = new JsonParser().parse(responseCreateGame).getAsJsonObject().get("data").getAsJsonObject().get("game_id").getAsString();
        Field field = new Field();
        field.randFillTenCells();
        PlaceShipsCommand placeShipsCommand = new PlaceShipsCommand(clientToken, gameId, field);
        String responsePlaceShips = gameConnector.sendGet(baseUrl + placeShipsCommand.getUrlPlaceShips(), clientToken);
        responseGameStatus = Main.getGameStatus(gameId, gameConnector, clientToken);
        Main.showField(responseGameStatus, clientToken, serverToken);
        StartCommand startCommand = new StartCommand(clientToken, gameId);
        String responseStart = gameConnector.sendGet(baseUrl + startCommand.getUrlPlaceShips(), clientToken);
        System.out.println("Starting game: " + responseStart);
        Field myShotsField = new Field();
        int shotsCount = 0;
        while (true) {
            int y2;
            int x2;
            if (!myShotsField.getCell(x2 = (int)(Math.random() * 10.0), y2 = (int)(Math.random() * 10.0)).getContent().getValue().equals("shot")) {
                ShootCommand shootCommand = new ShootCommand(clientToken, gameId, x2, y2);
                String responseShoot = gameConnector.sendGet(baseUrl + shootCommand.getUrlSoot(), clientToken);
                System.out.println("responseShoot:   " + responseShoot);
                responseGameStatus = Main.getGameStatus(gameId, gameConnector, clientToken);
                Main.showField(responseGameStatus, clientToken, serverToken);
                ++shotsCount;
            }
            if (shotsCount == 100) break;
            myShotsField.getCell(x2, y2).setContent(new CellContentShot());
        }
    }

    private static void showField(String responseGameStatus, UserToken clientToken, UserToken serverToken) {
        JsonObject jsonGameState = new JsonParser().parse(responseGameStatus).getAsJsonObject().get("data").getAsJsonObject();
        String status = jsonGameState.get("status").getAsString();
        AGameStatus gameStatus = new GameStatusDoesNotExist(GameID.fromString(gameId));
        switch (status) {
            case "running": {
                gameStatus = (AGameStatus)new GameStatusRunning().fromJson(jsonGameState);
                break;
            }
            case "new": {
                gameStatus = (AGameStatus)new GameStatusNew().fromJson(jsonGameState);
                break;
            }
            case "finished": {
                gameStatus = (AGameStatus)new GameStatusFinished().fromJson(jsonGameState);
            }
        }
        System.out.println("\n*** userClientField ***\n");
        Field userClientField = gameStatus.getState().getAssets(UserToken.parse(clientToken.toString())).getField();
        Main.printField(userClientField);
        System.out.println("\n*** userServerField ***\n");
        Field userServerField = gameStatus.getState().getAssets(UserToken.parse(serverToken.toString())).getField();
        Main.printField(userServerField);
    }

    private static String getGameStatus(String gameId, GameConnector gameConnector, UserToken clientToken) throws Exception {
        if (gameStatusCommand == null) {
            gameStatusCommand = new GameStatusCommand(clientToken, gameId);
        }
        return gameConnector.sendGet(baseUrl + gameStatusCommand.getUrlStatusGame(), clientToken);
    }

    private static void printField(Field field) {
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                String st;
                switch (st = field.getCell(i, j).getContent().getValue()) {
                    case "empty": {
                        field.getCell(i, j).getContent().setValue("*");
                        break;
                    }
                    case "ship": {
                        field.getCell(i, j).getContent().setValue("s");
                        break;
                    }
                    case "hit": {
                        field.getCell(i, j).getContent().setValue("X");
                        break;
                    }
                    case "miss": {
                        field.getCell(i, j).getContent().setValue("o");
                    }
                }
                System.out.print(" " + field.getCell(i, j).getContent().getValue());
            }
            System.out.println("");
        }
    }

    static {
        baseUrl = "http://localhost:8765";
    }
}

