/*
 * Decompiled with CFR 0.152.
 */
package org.testgame.tests;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.builtzwilnerapi.game.Field;
import org.builtzwilnerapi.game.cell.CellContentShip;
import org.testgame.game.Ship;
import org.testgame.languageadditions.ThreePredicate;

public class FieldChecker {
    boolean testIsPassed = true;

    public static void main(String[] args) {
        FieldChecker fieldChecker = new FieldChecker();
        Field field = fieldChecker.createCorrectFild();
        fieldChecker.checkField(field);
    }

    public boolean checkField(Field field) {
        FieldChecker fieldChecker = new FieldChecker();
        Map<Integer, Ship> shipsByRow = fieldChecker.getShipsByRow(field);
        Map<Integer, Ship> shipsByCol = fieldChecker.getShipsByCol(field);
        HashMap shipsByRowCordsNum = new HashMap();
        shipsByRow.forEach((key, value) -> value.ship.forEach(y -> shipsByRowCordsNum.put(new Integer[]{y[0], y[1]}, key)));
        HashMap shipsByColCordsNum = new HashMap();
        shipsByCol.forEach((key, value) -> value.ship.forEach(y -> shipsByColCordsNum.put(new Integer[]{y[0], y[1]}, key)));
        HashMap shipsResult = new HashMap();
        shipsByRowCordsNum.entrySet().stream().forEach(x -> shipsByColCordsNum.entrySet().stream().forEach(y -> {
            if (Arrays.equals((Object[])y.getKey(), (Object[])x.getKey())) {
                System.out.println("\n::::::::::::::::::::::::::::::::::::::::::::::::::::::::: \n");
                System.out.println("Ship number by Row " + x.getValue() + "   Ship number by Col  " + y.getValue());
                System.out.println("======= Ships By Row =======");
                ((Ship)shipsByRow.get(x.getValue())).printShip();
                System.out.println("======= Ships By Col =======");
                ((Ship)shipsByCol.get(y.getValue())).printShip();
                System.out.println("\n::::::::::::::::::::::::::::::::::::::::::::::::::::::::: \n");
                int shipsByRowSize = ((Ship)shipsByRow.get(x.getValue())).ship.size();
                int shipsByColSize = ((Ship)shipsByCol.get(y.getValue())).ship.size();
                if (shipsByRowSize == shipsByColSize & shipsByRowSize > 1) {
                    fieldChecker.testIsPassed = false;
                    System.out.println("Test is failed!");
                    System.out.println("See coordinates of collision!");
                }
                if (shipsByRowSize == shipsByColSize) {
                    shipsResult.put(((Ship)shipsByRow.get(x.getValue())).ship.hashCode(), shipsByRow.get(x.getValue()));
                } else if (shipsByRowSize > shipsByColSize) {
                    shipsResult.put(((Ship)shipsByRow.get(x.getValue())).ship.hashCode(), shipsByRow.get(x.getValue()));
                } else {
                    shipsResult.put(((Ship)shipsByCol.get(y.getValue())).ship.hashCode(), shipsByCol.get(y.getValue()));
                }
            }
        }));
        System.out.println("\n ===== All ships \n");
        shipsResult.entrySet().stream().forEach(x -> ((Ship)x.getValue()).printShip());
        return this.testIsPassed;
    }

    public Field createCorrectFild() {
        Field field = new Field();
        int[][] fieldArray = new int[][]{{0, 0, 0, 0, 0, 1, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 0, 0, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 0, 1, 0, 1, 1}, {0, 0, 0, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 1, 1, 0, 1, 0, 0, 0}};
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 10; ++y) {
                if (fieldArray[x][y] != 1) continue;
                field.getCell(x, y).setContent(new CellContentShip());
            }
        }
        return field;
    }

    public void checkCell() {
        ThreePredicate<Integer, Integer, Field> def = this::checkCellContainShip;
        ThreePredicate<Integer, Integer, Field> LShift = (x, y, field) -> {
            x = x - 1;
            return this.checkCellContainShip((int)x, (int)y, (Field)field);
        };
        ThreePredicate<Integer, Integer, Field> RShift = (x, y, field) -> {
            x = x + 1;
            return this.checkCellContainShip((int)x, (int)y, (Field)field);
        };
        ThreePredicate<Integer, Integer, Field> DShift = (x, y, field) -> {
            y = y - 1;
            return this.checkCellContainShip((int)x, (int)y, (Field)field);
        };
        ThreePredicate<Integer, Integer, Field> TShift = (x, y, field) -> {
            y = y + 1;
            return this.checkCellContainShip((int)x, (int)y, (Field)field);
        };
        ThreePredicate<Integer, Integer, Field> LDShift = (x, y, field) -> {
            x = x - 1;
            y = y - 1;
            return this.checkCellContainShip((int)x, (int)y, (Field)field);
        };
        ThreePredicate<Integer, Integer, Field> RDShift = (x, y, field) -> {
            x = x + 1;
            y = y - 1;
            return this.checkCellContainShip((int)x, (int)y, (Field)field);
        };
        ThreePredicate<Integer, Integer, Field> LTShift = (x, y, field) -> {
            x = x - 1;
            y = y + 1;
            return this.checkCellContainShip((int)x, (int)y, (Field)field);
        };
        ThreePredicate<Integer, Integer, Field> RTShift = (x, y, field) -> {
            x = x + 1;
            y = y + 1;
            return this.checkCellContainShip((int)x, (int)y, (Field)field);
        };
    }

    public boolean checkCellContainShip(int x, int y, Field field) {
        return field.getCell(x, y).getContent().getValue().equals("ship");
    }

    public Map<Integer, Ship> getShipsByRow(Field field) {
        int cellShipNumber = 0;
        TreeMap<Integer, Ship> shipsMap = new TreeMap<Integer, Ship>();
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 10; ++y) {
                if (!field.checkCellContainShip(x, y)) continue;
                if (y == 0) {
                    shipsMap.put(++cellShipNumber, new Ship());
                } else if (!field.checkCellContainShip(x, y - 1)) {
                    shipsMap.put(++cellShipNumber, new Ship());
                }
                ((Ship)shipsMap.get(cellShipNumber)).addCell(x, y);
            }
        }
        return shipsMap;
    }

    public Map<Integer, Ship> getShipsByCol(Field field) {
        int cellShipNumber = 0;
        TreeMap<Integer, Ship> shipsMap = new TreeMap<Integer, Ship>();
        for (int y = 0; y < 10; ++y) {
            for (int x = 0; x < 10; ++x) {
                if (!field.checkCellContainShip(x, y)) continue;
                if (x == 0) {
                    shipsMap.put(++cellShipNumber, new Ship());
                } else if (!field.checkCellContainShip(x - 1, y)) {
                    shipsMap.put(++cellShipNumber, new Ship());
                }
                ((Ship)shipsMap.get(cellShipNumber)).addCell(x, y);
            }
        }
        return shipsMap;
    }

    public void printShipsMap(Map<Integer, Ship> shipsMap) {
        shipsMap.forEach((key, value) -> {
            System.out.println(key + " ");
            value.printShip();
        });
    }
}

