/*
 * Decompiled with CFR 0.152.
 */
package org.testgame.game;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.builtzwilnerapi.game.Field;
import org.builtzwilnerapi.game.GameID;
import org.builtzwilnerapi.game.status.AGameStatus;
import org.builtzwilnerapi.game.status.GameStatusDoesNotExist;
import org.builtzwilnerapi.game.status.GameStatusFinished;
import org.builtzwilnerapi.game.status.GameStatusNew;
import org.builtzwilnerapi.game.status.GameStatusRunning;
import org.builtzwilnerapi.user.UserToken;

public class ServerResponseHandler {
    public Field createFieldFromResponse(String responseGameStatus, UserToken token, String gameId) {
        JsonObject jsonGameState = new JsonParser().parse(responseGameStatus).getAsJsonObject().get("data").getAsJsonObject();
        String status = jsonGameState.get("status").getAsString();
        AGameStatus gameStatus = new GameStatusDoesNotExist(GameID.fromString(gameId));
        switch (status) {
            case "running": {
                gameStatus = (AGameStatus)new GameStatusRunning().fromJson(jsonGameState);
                break;
            }
            case "new": {
                gameStatus = (AGameStatus)new GameStatusNew().fromJson(jsonGameState);
                break;
            }
            case "finished": {
                gameStatus = (AGameStatus)new GameStatusFinished().fromJson(jsonGameState);
            }
        }
        return gameStatus.getState().getAssets(UserToken.parse(token.toString())).getField();
    }

    public boolean getStatusRunFinished(String responseGameStatus, String gameId) {
        boolean result = true;
        JsonObject jsonGameState = new JsonParser().parse(responseGameStatus).getAsJsonObject().get("data").getAsJsonObject();
        String status = jsonGameState.get("status").getAsString();
        GameStatusDoesNotExist gameStatus = new GameStatusDoesNotExist(GameID.fromString(gameId));
        switch (status) {
            case "running": {
                result = true;
                break;
            }
            case "new": {
                result = true;
                break;
            }
            case "finished": {
                result = false;
            }
        }
        return result;
    }
}

