/*
 * Decompiled with CFR 0.152.
 */
package org.builtzwilnerapi.game;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.bson.Document;
import org.builtzwilnerapi.db.json.AJsonBson;
import org.builtzwilnerapi.game.player.PlayerAsset;
import org.builtzwilnerapi.game.status.AGameStatus;
import org.builtzwilnerapi.game.status.GameStatusNew;
import org.builtzwilnerapi.user.AUser;
import org.builtzwilnerapi.user.UserToken;

public class GameState
extends AJsonBson<GameState> {
    HashMap<UserToken, PlayerAsset> playerAssets;
    ArrayList<UserToken> usersOrder;
    UserToken currentTurnUserToken;
    int turnNumber;
    AGameStatus gameStatusObject;

    public void init() {
        this.playerAssets = new HashMap();
        this.usersOrder = new ArrayList();
    }

    public GameState(AGameStatus gameStatusObject) {
        this.gameStatusObject = gameStatusObject;
    }

    public GameState(AGameStatus gameStatusObject, Collection<PlayerAsset> assets, List<UserToken> order, UserToken currentTurnUserToken) {
        this(gameStatusObject);
        this.init();
        this.usersOrder.addAll(order);
        assets.stream().forEach(asset -> this.playerAssets.put(asset.getUserToken(), (PlayerAsset)asset));
        this.currentTurnUserToken = currentTurnUserToken;
    }

    public GameState(Collection<PlayerAsset> assets, UserToken currentTurnUserToken) {
        this.init();
        assets.stream().forEach(asset -> {
            this.playerAssets.put(asset.getUserToken(), (PlayerAsset)asset);
            this.usersOrder.add(asset.getUserToken());
        });
        this.currentTurnUserToken = currentTurnUserToken;
    }

    public UserToken getCurrentTurnUserToken() {
        return this.currentTurnUserToken;
    }

    public PlayerAsset getAssets(UserToken user) {
        return this.playerAssets.get(user);
    }

    @Override
    public JsonObject toJson() {
        JsonObject enc = new JsonObject();
        JsonObject encAssets = new JsonObject();
        this.playerAssets.values().stream().forEach(asset -> {
            JsonObject jsonAsset = asset.toJson();
            encAssets.add(asset.getUserToken().toString(), (JsonElement)jsonAsset);
        });
        enc.add("assets", (JsonElement)encAssets);
        JsonArray encUsersOrder = new JsonArray();
        this.usersOrder.stream().forEach(user -> encUsersOrder.add(user.toString()));
        enc.add("usersOrder", (JsonElement)encUsersOrder);
        enc.addProperty("currentTurnUserToken", this.currentTurnUserToken.toString());
        enc.addProperty("turnNumber", (Number)this.turnNumber);
        return enc;
    }

    @Override
    public Document toBson() {
        Document enc = new Document();
        Document encAssets = new Document();
        this.playerAssets.values().stream().forEach(asset -> {
            Document encAsset = asset.toBson();
            encAssets.put(asset.getUserToken().toString(), (Object)encAsset);
        });
        enc.put("assets", (Object)encAssets);
        LinkedList encUsersOrder = new LinkedList();
        this.usersOrder.stream().forEach(user -> encUsersOrder.add(user.toString()));
        enc.put("usersOrder", encUsersOrder);
        enc.put("currentTurnUserToken", (Object)this.currentTurnUserToken.toString());
        enc.put("turnNumber", (Object)this.turnNumber);
        return enc;
    }

    @Override
    public void doFromJson(JsonObject dec) {
        this.init();
        JsonObject encAssets = dec.getAsJsonObject("assets");
        encAssets.entrySet().stream().forEach(entry -> {
            UserToken userToken = UserToken.parse((String)entry.getKey());
            JsonObject decAsset = ((JsonElement)entry.getValue()).getAsJsonObject();
            this.playerAssets.put(userToken, (PlayerAsset)new PlayerAsset().fromJson(decAsset));
        });
        JsonArray encUsersOrder = dec.getAsJsonArray("usersOrder");
        encUsersOrder.forEach(user -> this.usersOrder.add(UserToken.parse(user.toString())));
        this.currentTurnUserToken = UserToken.parse(dec.get("currentTurnUserToken").getAsString());
        this.turnNumber = dec.get("turnNumber").getAsInt();
    }

    @Override
    public void doFromBson(Document dec) {
        this.init();
        Document encAssets = (Document)dec.get((Object)"assets");
        encAssets.entrySet().stream().forEach(entry -> {
            UserToken userToken = UserToken.parse((String)entry.getKey());
            Document decAsset = (Document)entry.getValue();
            this.playerAssets.put(userToken, (PlayerAsset)new PlayerAsset().fromBson(decAsset));
        });
        List encUsersOrder = (List)dec.get((Object)"usersOrder");
        encUsersOrder.forEach(user -> this.usersOrder.add(UserToken.parse(user.toString())));
        this.currentTurnUserToken = UserToken.parse(dec.get((Object)"currentTurnUserToken").toString());
        this.turnNumber = dec.getInteger((Object)"turnNumber");
    }

    public static GameState createNewForUsers(AGameStatus status, AUser ... users) {
        LinkedList<PlayerAsset> assets = new LinkedList<PlayerAsset>();
        LinkedList<UserToken> order = new LinkedList<UserToken>();
        Arrays.stream(users).forEach(user -> {
            assets.add(new PlayerAsset((AUser)user));
            order.add(user.getUserToken());
        });
        GameState res = new GameState(status, assets, order, users[0].getUserToken());
        return res;
    }

    public UserToken getNextTurnUserToken(UserToken fromToken) {
        int nextTurnUserTokenIdx = this.usersOrder.indexOf(fromToken) + 1;
        if (nextTurnUserTokenIdx >= this.usersOrder.size()) {
            nextTurnUserTokenIdx = 0;
        }
        return this.usersOrder.get(nextTurnUserTokenIdx);
    }

    public int getCurrentTurnUserOrderIndex() {
        return this.usersOrder.indexOf(this.getCurrentTurnUserToken());
    }

    public UserToken getNextTurnUserToken() {
        return this.getNextTurnUserToken(this.getCurrentTurnUserToken());
    }

    public UserToken advanceCurrentTurnUser() {
        this.currentTurnUserToken = this.getNextTurnUserToken();
        return this.currentTurnUserToken;
    }

    public UserToken setCurrentTurnUserNextAfter(UserToken token) {
        this.currentTurnUserToken = this.getNextTurnUserToken(token);
        return this.currentTurnUserToken;
    }

    public List<UserToken> getUpcomingAiPlayers(UserToken fromToken) {
        LinkedList<UserToken> upcomingAiPlayers = new LinkedList<UserToken>();
        UserToken temp = fromToken;
        while (temp.isAi()) {
            upcomingAiPlayers.add(temp);
            temp = this.getNextTurnUserToken(temp);
        }
        return upcomingAiPlayers;
    }

    public List<UserToken> getUpcomingAiPlayers() {
        return this.getUpcomingAiPlayers(this.getNextTurnUserToken());
    }

    public void advanceTurnNumber() {
        ++this.turnNumber;
        System.out.println("=================================================================================GAME STATE " + this.gameStatusObject.getGameId() + ", turn " + this.turnNumber + "\nnow user " + this.getCurrentTurnUserToken() + "\n=================================================================================");
    }

    public void setGameStatusObject(GameStatusNew gameStatusObject) {
        this.gameStatusObject = gameStatusObject;
    }
}

