/*
 * Decompiled with CFR 0.152.
 */
package org.builtzwilnerapi.game;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.bson.Document;
import org.builtzwilnerapi.db.json.AJsonBson;
import org.builtzwilnerapi.game.Cell;
import org.builtzwilnerapi.game.cell.CellContentShip;
import org.builtzwilnerapi.view.IHasView;

public class Field
extends AJsonBson<Field>
implements IHasView {
    ArrayList<ArrayList<Cell>> cells;

    public Field(ArrayList<ArrayList<Cell>> cells) {
        this.cells = cells;
    }

    public Field() {
        this.cells = new ArrayList();
        for (int x = 0; x < 10; ++x) {
            ArrayList<Cell> row = new ArrayList<Cell>();
            for (int y = 0; y < 10; ++y) {
                row.add(new Cell());
            }
            this.cells.add(row);
        }
    }

    public ArrayList<ArrayList<Cell>> getCells() {
        return this.cells;
    }

    @Override
    public JsonObject toJson() {
        JsonObject enc = new JsonObject();
        JsonArray encRows = new JsonArray();
        for (ArrayList<Cell> row : this.cells) {
            JsonArray encRow = new JsonArray();
            for (Cell cell : row) {
                encRow.add((JsonElement)cell.toJson());
            }
            encRows.add((JsonElement)encRow);
        }
        enc.add("cells", (JsonElement)encRows);
        return enc;
    }

    @Override
    public Document toBson() {
        Document enc = new Document();
        LinkedList encRows = new LinkedList();
        for (ArrayList<Cell> row : this.cells) {
            LinkedList<Document> encRow = new LinkedList<Document>();
            for (Cell cell : row) {
                encRow.add(cell.toBson());
            }
            encRows.add(encRow);
        }
        enc.put("cells", encRows);
        return enc;
    }

    @Override
    public void doFromJson(JsonObject dec) {
        this.cells = new ArrayList();
        JsonArray decRows = dec.getAsJsonArray("cells");
        decRows.forEach(decRow -> {
            JsonArray row = decRow.getAsJsonArray();
            ArrayList rowCells = new ArrayList();
            row.forEach(cell -> rowCells.add(new Cell().fromJson(cell.getAsJsonObject())));
            this.cells.add(rowCells);
        });
    }

    @Override
    public void doFromBson(Document dec) {
        this.cells = new ArrayList();
        List decRows = (List)dec.get((Object)"cells");
        decRows.forEach(decRow -> {
            ArrayList rowCells = new ArrayList();
            decRow.forEach(cell -> {
                Cell ce = (Cell)new Cell().fromBson((Document)cell);
                rowCells.add(ce);
            });
            this.cells.add(rowCells);
        });
    }

    public Cell getCell(int x, int y) {
        return this.cells.get(y).get(x);
    }

    public void randFillTenCells() {
        int countNum = 0;
        do {
            int x = (int)(Math.random() * 9.0);
            int y = (int)(Math.random() * 9.0);
            if (this.cells.get(y).get(x).getContent().equals("empty")) continue;
            this.cells.get(y).get(x).setContent(new CellContentShip());
            ++countNum;
        } while (countNum <= 10);
    }

    public void printField() {
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 10; ++y) {
                String st = this.cells.get(x).get(y).getContent().getValue();
                String symbol = "";
                switch (st) {
                    case "empty": {
                        symbol = "*";
                        break;
                    }
                    case "ship": {
                        symbol = "s";
                        break;
                    }
                    case "hit": {
                        symbol = "X";
                        break;
                    }
                    case "miss": {
                        symbol = "o";
                    }
                }
                System.out.print(" " + symbol);
            }
            System.out.println("");
        }
    }

    public boolean compareFild(Field field1, Field field2) {
        boolean result = true;
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 10; ++y) {
                if (field1.getCell(x, y).getContent().getValue().equals(field2.getCell(x, y).getContent().getValue())) continue;
                result = false;
            }
        }
        return result;
    }

    public boolean compareFildExcludeOneCell(Field field1, Field field2, int i, int j) {
        boolean result = true;
        for (int y = 0; y < 10; ++y) {
            for (int x = 0; x < 10; ++x) {
                if (x == i && y == j || field1.getCell(x, y).getContent().getValue().equals(field2.getCell(x, y).getContent().getValue())) continue;
                result = false;
            }
        }
        return result;
    }

    public boolean compareFildCell(Field field1, Field field2, int x, int y) {
        boolean result = true;
        if (!field1.getCell(x, y).getContent().getValue().equals(field2.getCell(x, y).getContent().getValue())) {
            result = false;
        }
        return result;
    }

    public boolean checkThatFieldIsEmpty() {
        boolean result = true;
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 10; ++y) {
                if (this.cells.get(x).get(y).getContent().getValue().equals("empty")) continue;
                result = false;
            }
        }
        return result;
    }

    public boolean checkCellContainShip(int x, int y) {
        return this.cells.get(x).get(y).getContent().getValue().equals("ship");
    }

    public int countShipCells() {
        int countShipCells = 0;
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 10; ++y) {
                if (!this.checkCellContainShip(x, y)) continue;
                ++countShipCells;
            }
        }
        return countShipCells;
    }
}

