/*
 * Decompiled with CFR 0.152.
 */
package com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus;

import com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus.GameStateDataStatus;
import com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus.PlayerAsset;
import com.socialquantum.battleship.gameapi.types.base.ExecutionStatus;
import com.socialquantum.battleship.gameapi.types.base.UserToken;
import com.socialquantum.battleship.gameapi.types.response.GameStatus;
import com.socialquantum.battleship.gameapi.utils.TransformUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GameStatusResponseData
implements GameStatus {
    private ExecutionStatus status;
    private final Data data = new Data();

    @Override
    public List<UserToken> usersOrder() {
        return Collections.unmodifiableList(this.data.state.usersOrder.stream().map(TransformUtils::userToken).collect(Collectors.toList()));
    }

    @Override
    public ExecutionStatus status() {
        return this.status;
    }

    @Override
    public UserToken currentTurnUserToken() {
        return TransformUtils.userToken(this.data.state.currentTurnUserToken);
    }

    @Override
    public int turnNumber() {
        return this.data.state.turnNumber;
    }

    @Override
    public PlayerAsset asset(UserToken playerToken) {
        return this.data.state.assets.computeIfAbsent(playerToken.value(), asset -> {
            throw new IllegalStateException("asset " + asset + " not found ");
        });
    }

    public GameStateDataStatus dataStatus() {
        return this.data.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GameStatusResponseData)) {
            return false;
        }
        GameStatusResponseData that = (GameStatusResponseData)o;
        if (this.status != that.status) {
            return false;
        }
        return this.data.equals(that.data);
    }

    public int hashCode() {
        int result = this.status != null ? this.status.hashCode() : 0;
        result = 31 * result + this.data.hashCode();
        return result;
    }

    private static class Data {
        private String game_id;
        private State state = new State();
        private GameStateDataStatus status;

        private Data() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data data = (Data)o;
            if (this.game_id != null ? !this.game_id.equals(data.game_id) : data.game_id != null) {
                return false;
            }
            if (this.state != null ? !this.state.equals(data.state) : data.state != null) {
                return false;
            }
            return this.status == data.status;
        }

        public int hashCode() {
            int result = this.game_id != null ? this.game_id.hashCode() : 0;
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            return result;
        }

        private class State {
            private final Map<String, PlayerAsset> assets = new HashMap<String, PlayerAsset>();
            private final List<String> usersOrder = new ArrayList<String>();
            private String currentTurnUserToken;
            private int turnNumber;

            private State() {
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof State)) {
                    return false;
                }
                State state = (State)o;
                if (this.turnNumber != state.turnNumber) {
                    return false;
                }
                if (!this.assets.equals(state.assets)) {
                    return false;
                }
                if (!this.usersOrder.equals(state.usersOrder)) {
                    return false;
                }
                return this.currentTurnUserToken != null ? this.currentTurnUserToken.equals(state.currentTurnUserToken) : state.currentTurnUserToken == null;
            }

            public int hashCode() {
                int result = this.assets.hashCode();
                result = 31 * result + this.usersOrder.hashCode();
                result = 31 * result + (this.currentTurnUserToken != null ? this.currentTurnUserToken.hashCode() : 0);
                result = 31 * result + this.turnNumber;
                return result;
            }
        }
    }
}

