package com.socialquantum.battleship.gameapi.internal.types;

/**
 *
 * Created 29/06/17 08:34
 * @author Vladimir Bogodukhov
 **/
public interface OperationResult<Success, Error> {

    enum Result {
        SUCCESS,
        ERROR
    }

    /**
     *
     * @return код ответа Http
     */
    int code();


    /**
     *
     * @return результат выполнени операции
     */
    Result result();


    /**
     * @return Данные успешного ответа.
     */
    Success successData();

    /**
     * @return Данные ответа об ошибке.
     */
    Error errorData();



}
