package com.socialquantum.battleship.gameapi.internal.types;

import java.util.Objects;

/**
 * Created 11/07/17 09:49
 *
 * @author Vladimir Bogodukhov 
 **/
public final class DefaultOperationResult<S, E> implements OperationResult<S, E> {
    private final int code;
    private final S successData;
    private final E errorData;
    private final Result result;

    public DefaultOperationResult(int code, Result result, S successData, E errorData) {
        this.code = code;
        this.result = Objects.requireNonNull(result);
        switch (result) {
            case SUCCESS:
                Objects.requireNonNull(successData);
                break;

            case ERROR:
                Objects.requireNonNull(errorData);
                break;
        }

        this.successData = successData;
        this.errorData = errorData;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public Result result() {
        return result;
    }

    @Override
    public S successData() {
        return successData;
    }

    @Override
    public E errorData() {
        return errorData;
    }
}

