package com.socialquantum.battleship.gameapi.internal.dataobjects.snapshotlist;

import com.socialquantum.battleship.gameapi.types.base.ExecutionStatus;
import com.socialquantum.battleship.gameapi.types.base.SnapshotId;
import com.socialquantum.battleship.gameapi.types.response.SnapshotList;
import com.socialquantum.battleship.gameapi.utils.TransformUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * // {
 * //     "status": "OK",
 * //     "data": {
 * //         "snapshot_ids": ["6890b2de-8ddc-49cb-8f79-db61f49dbddc", "c571d1f0-fc1c-4c33-bdf9-23ad6bdd652e",]
 * //     }
 * // }
 * Created 06/07/17 15:22
 *
 * @author Vladimir Bogodukhov
 **/
public class SnapshotListResponseData implements SnapshotList {

    private static class Data {
        private final List<String> snapshot_ids = new ArrayList<>();
    }

    private ExecutionStatus status;
    private final Data data = new Data();


    public ExecutionStatus status() {
        return status;
    }

    public List<SnapshotId> snapshots() {
        return data.snapshot_ids.stream().map(TransformUtils::snapshotId).collect(Collectors.toList());
    }
}
