package com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus;

import com.socialquantum.battleship.gameapi.types.base.Asset;
import com.socialquantum.battleship.gameapi.types.base.CellStatus;
import com.socialquantum.battleship.gameapi.types.base.UserToken;
import com.socialquantum.battleship.gameapi.utils.TransformUtils;

/**
 * Created 11/07/17 09:10
 *
 * @author Vladimir Bogodukhov 
 **/
public class PlayerAsset implements Asset {
    private String user;
    private final Field field = new Field();

    public CellStatus cellStatus(int x, int y) {
        return field.cells.get(y).get(x).content.value;
    }

    @Override
    public UserToken userToken() {
        return TransformUtils.userToken(user);
    }

//    @Override !NB! смотреть тут
    public Field field() {
        return field;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PlayerAsset)) return false;

        PlayerAsset asset = (PlayerAsset) o;

        if (user != null ? !user.equals(asset.user) : asset.user != null) return false;
        return field.equals(asset.field);
    }

    @Override
    public int hashCode() {
        int result = user != null ? user.hashCode() : 0;
        result = 31 * result + field.hashCode();
        return result;
    }
}

