package com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus;

import java.util.Arrays;
import java.util.Objects;

/**
 * Текущий статус игры
 * Created 30/06/17 09:32
 *
 * @author Vladimir Bogodukhov
 **/
public enum GameStateDataStatus {

    /**
     * new игра создана, но не начата. Переводится в состояние `running` командой начала игры
     */
    NEW("new"),

    /**
     * `running` -- игра проводится в данный момент
     */
    RUNNING("running"),

    /**
     * `finished` -- игра окончена. Данное состояние устанавливается когда сервер решает, что один из игроков
     */
    FINISHED("finished");

    private final String ident;

    GameStateDataStatus(String ident) {
        this.ident = Objects.requireNonNull(ident);
    }

    public String ident() {
        return ident;
    }

    public static GameStateDataStatus elementByName(String ident) {
        if (ident == null) return null;
        return Arrays.stream(GameStateDataStatus.values()).
                filter(status -> status.ident().equals(ident)).findFirst().
                orElseThrow(() -> new IllegalStateException("ident " + ident + " is not found"));
    }


}

