/*
 * Decompiled with CFR 0.152.
 */
package com.sprunck.druid.riemann;

import com.aphyr.riemann.client.EventDSL;
import com.aphyr.riemann.client.RiemannClient;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.metamx.common.ISE;
import com.metamx.common.guava.DefaultingHashMap;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.core.Emitter;
import com.metamx.emitter.core.Event;
import com.metamx.emitter.service.ServiceEvent;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.sprunck.druid.riemann.RiemannEmitterConfig;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiemannEmitter
implements Emitter {
    private RiemannClient client;
    private final RiemannEmitterConfig config;
    private static final DefaultingHashMap<String, EventDSLBuilder> BUILDERS = new DefaultingHashMap((Supplier)new Supplier<EventDSLBuilder>(){

        public EventDSLBuilder get() {
            return new DefaultEventDSLBuilder();
        }
    });
    private final AtomicBoolean started = new AtomicBoolean(false);

    public RiemannEmitter(RiemannEmitterConfig config) {
        this.config = config;
    }

    @LifecycleStart
    public void start() {
        boolean alreadyStarted = this.started.getAndSet(true);
        if (!alreadyStarted) {
            try {
                this.client = RiemannClient.tcp((String)this.config.getHost(), (int)this.config.getPort());
                this.client.connect();
            }
            catch (IOException io) {
                throw Throwables.propagate((Throwable)io);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emit(Event event) {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (!this.started.get()) {
                throw new RejectedExecutionException("Service not started.");
            }
        }
        try {
            ((EventDSLBuilder)BUILDERS.get((Object)event.getFeed())).build(event, this.client).send().deref(5000L, TimeUnit.MILLISECONDS);
        }
        catch (IOException io) {
            throw Throwables.propagate((Throwable)io);
        }
    }

    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void close() throws IOException {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            this.started.set(false);
            this.client.close();
        }
    }

    public static Map<String, String> event2Attr(Event event) {
        return Maps.transformValues((Map)event.toMap(), (Function)new Function<Object, String>(){

            public String apply(Object o) {
                return o.toString();
            }
        });
    }

    static {
        BUILDERS.put((Object)"metrics", (Object)new MetricsEventDSLBuilder());
    }

    private static class MetricsEventDSLBuilder
    implements EventDSLBuilder {
        private MetricsEventDSLBuilder() {
        }

        public EventDSL build(Event event, RiemannClient client) {
            ServiceMetricEvent metricEvent = (ServiceMetricEvent)event;
            String riemannService = metricEvent.getService() + ' ' + metricEvent.getMetric();
            EventDSL dsl = client.event().host(metricEvent.getHost()).service(riemannService).time(metricEvent.getCreatedTime().getMillis() / 1000L);
            try {
                Double metric = metricEvent.getValue().doubleValue();
                if (metric == Math.ceil(metric)) {
                    dsl.metric(metric.longValue());
                } else {
                    dsl.metric(metric.doubleValue());
                }
            }
            catch (NumberFormatException e) {
                throw new ISE((Throwable)e, "Bad metric format: %s", new Object[]{metricEvent.getMetric()});
            }
            return dsl;
        }
    }

    private static class DefaultEventDSLBuilder
    implements EventDSLBuilder {
        private DefaultEventDSLBuilder() {
        }

        public EventDSL build(Event event, RiemannClient client) {
            ServiceEvent serviceEvent = (ServiceEvent)event;
            return client.event().host(serviceEvent.getHost()).service(serviceEvent.getService()).time(serviceEvent.getCreatedTime().getMillis() / 1000L).attributes(RiemannEmitter.event2Attr(event));
        }
    }

    public static interface EventDSLBuilder {
        public EventDSL build(Event var1, RiemannClient var2);
    }
}

