(ns dawdle.channel
  (:require [dawdle.web :refer :all]))

(defn do-with-channel
  [channel channels-fn groups-fn im-fn params]
   (if-let [f (case (get channel 0)
             \C channels-fn
             \G groups-fn
             \D im-fn
             )]
     (apply f params)
     (throw (IllegalArgumentException. "No method defined for the given channel type"))))

(defn channel-archive
  ([token channel] (channel-archive token channel {}))
  ([token channel params]
    (do-with-channel channel channels-archive groups-archive nil [token channel params])))

(defn channel-history
  ([token channel] (channel-history token channel {}))
  ([token channel params]
    (do-with-channel channel channels-history groups-history im-history [token channel params])))

(defn channel-info
  ([token channel] (channel-info token channel {}))
  ([token channel params]
    (do-with-channel channel channels-info groups-info im-info [token channel params])))

(defn channel-invite
  ([token user channel] (channel-invite token user channel {}))
  ([token user channel params]
    (do-with-channel channel channels-invite groups-invite nil [token user channel params])))

(defn channel-kick
  ([token user channel] (channel-kick token user channel {}))
  ([token user channel params]
    (do-with-channel channel channels-kick groups-kick nil [token user channel params])))

(defn channel-leave
  ([token channel] (channel-leave token channel {}))
  ([token channel params]
    (do-with-channel channel channels-leave groups-leave im-close [token channel params])))

(defn channel-mark
  ([token channel] (channel-mark token channel {}))
  ([token channel params]
    (do-with-channel channel channels-mark groups-mark im-mark [token channel params])))

(defn channel-rename
  ([token channel name] (channel-rename token channel name {}))
  ([token channel name params]
    (do-with-channel channel channels-rename groups-rename nil [token channel name params])))

(defn channel-set-purpose
  ([token channel purpose] (channel-set-purpose token channel purpose {}))
  ([token channel purpose params]
    (do-with-channel channel channels-set-purpose groups-set-purpose nil [token channel purpose params])))

(defn channel-set-topic
  ([token channel topic] (channel-set-topic token channel topic {}))
  ([token channel topic params]
    (do-with-channel channel channels-set-topic groups-set-topic nil [token channel topic params])))

(defn channel-unarchive
  ([token channel] (channel-unarchive token channel {}))
  ([token channel params]
    (do-with-channel channel channels-unarchive groups-unarchive nil [token channel params])))
