# chard

Ensures that the SQS queues and SNS topics you depend on exist when your app starts.

Makes it easy to:

* create a queue with sensible defaults (e.g. redrive policy and dead-letter queue)
* subscribe your queue to one or more SNS topics.

Uses [nervous-systems/fink-nottle](https://github.com/nervous-systems/fink-nottle) under the hood.

## Usage

[![Clojars Project](http://clojars.org/chard/latest-version.svg)](http://clojars.org/chard)

The below example creates a queue called "my-queue", with:

 * a redrive policy of 5 max tries
 * a dead letter queue named "my-queue-dl" (created if it doesn't exist)
 * a subscription to the SNS topic "my-topic" (created if it doesn't exist), with the appropriate queue policy
 
The queue URL is returned. If the queue already exists, function is idempotent.

    (chard.sqs/get-or-create-queue!!
      {:access-key (System/getenv "AWS_ACCESS_KEY_ID")
       :secret-key (System/getenv "AWS_SECRET_ACCESS_KEY")
       :region "us-west-2"}
      "my-queue"
      {:subscriptions ["my-topic"]})

Just create a queue, no subscriptions:

    (chard.sqs/get-or-create-queue!! creds "my-queue")

Customize number of tries in redrive policy:

    (chard.sqs/get-or-create-queue!! creds "my-queue" {:redrive 3})

Without redrive policy:

    (chard.sqs/get-or-create-queue!! creds "my-queue" {:redrive false})

Returns an SNS topic URN:

    (chard.sns/get-or-create-topic!! creds "my-topic")

## Todo

* Tests!

## License

Copyright © 2015 Java Beach, Inc (dba Spright)

Released under an MIT license.
