(ns pc.api
  (:require #?(:clj [clojure.spec :as s]
               :cljs [cljs.spec :as s])))

(s/def ::alphanumeric (s/and string? (partial re-find #"^[\w \.!?-]+$")))
(s/def ::degree (s/and float? #(and (<= % 180) (>= % -180))))
(s/def ::latitude ::degree)
(s/def ::longitude ::degree)
(s/def ::gps-coord (s/keys :req [::latitude ::longitude]))
(s/def ::meter-radius (s/and float? pos?))
(s/def ::km-radius (s/and float? pos?))
(s/def ::google-auth-token string?)

(s/def ::description
  (s/with-gen ::alphanumeric
    #(s/gen #{"Organic Naval Orange"
              "Organic Fuji Apple"
              "Naval Orange"
              "Blah Blah Blah"})))

(s/def ::search-term
  (s/with-gen ::alphanumeric
    #(s/gen #{"or" "orange" "organic" "abc"})))

(s/def ::pc-auth-token
  (s/with-gen string?
    #(s/gen #{"eyJhbGciOiJBMjU2S1ciLCJ0eXAiOiJKV1MiLCJlbmMiOiJBMTI4R0NNIn0=.0toJcgrYd_STcj7D0UBj1Ko0ZXB2Lzhk.rQu3TLr07TqdtoDd.FS8emmJTSVLJTqa6nUJcE_YKuvjXAyyATNmPy0zh5Pt5DAVUpDHtYdJWhdfuWvefXN9bzxLQ.KZXftQkaKhCJidwSD7IZYg"})))

(s/def ::auto-complete (s/keys :req [::search-term ::gps-coord ::km-radius]))
(s/def ::matching-products (s/keys :req [::description ::gps-coord ::km-radius]))
(s/def ::get-google-user (s/keys :req [::google-auth-token ::gps-coord]))
(s/def ::pc-auth-token-keyspec (s/keys :req [::pc-auth-token]))
(s/def ::nearby (s/keys :req [::pc-auth-token ::gps-coord ::meter-radius]))

(defmulti perform-action ::action)

(defmethod perform-action :nearby [_] ::nearby)

(defmethod perform-action :get-google-user [_] ::get-google-user)

(defmethod perform-action
  :auto-complete [_]
  (s/merge ::pc-auth-token-keyspec ::auto-complete))

(defmethod perform-action
  :matching-products [_]
  (s/merge ::pc-auth-token-keyspec ::matching-products))

(s/def ::message (s/multi-spec perform-action ::action))
