/*
 * Decompiled with CFR 0.152.
 */
package com.socialquantum.battleship.gameapi.internal.connector;

import com.socialquantum.battleship.gameapi.internal.dataobjects.creategame.CreateGameRequestData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.creategame.CreateGameResponseData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.defaultresponse.DefaultResponse;
import com.socialquantum.battleship.gameapi.internal.dataobjects.deletegame.DeleteGameRequestData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.deletegame.DeleteGameResponseData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.deletesnapshot.DeleteSnapshotRequestData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.deletesnapshot.DeleteSnapshotResponseData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.gamelist.GameListRequestData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.gamelist.GameListResponseData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus.GameStatusRequestData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus.GameStatusResponseData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.move.ShootRequestData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.move.ShootResponseData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.placeships.PlaceShipsResponseData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.restoresnapshot.RestoreSnapshotRequestData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.restoresnapshot.RestoreSnapshotResponseData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.savesnapshot.SaveSnapshotRequestData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.savesnapshot.SaveSnapshotResponseData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.snapshotlist.SnapshotListRequestData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.snapshotlist.SnapshotListResponseData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.startgame.StartGameRequestData;
import com.socialquantum.battleship.gameapi.internal.dataobjects.startgame.StartGameResponseData;
import com.socialquantum.battleship.gameapi.internal.serializationutils.SerializationDeserializationFactory;
import com.socialquantum.battleship.gameapi.internal.types.OperationResult;
import com.socialquantum.battleship.gameapi.internal.utils.GameUtils;
import com.socialquantum.battleship.gameapi.types.base.ExecutionStatus;
import com.socialquantum.battleship.gameapi.types.base.GameId;
import com.socialquantum.battleship.gameapi.types.base.SnapshotId;
import com.socialquantum.battleship.gameapi.types.base.UserToken;
import com.socialquantum.battleship.gameapi.types.connector.GameConnector;
import com.socialquantum.battleship.gameapi.types.exceptions.OperationException;
import com.socialquantum.battleship.gameapi.types.exceptions.OperationFailed;
import com.socialquantum.battleship.gameapi.types.request.placeships.ShipsPlacementRequest;
import com.socialquantum.battleship.gameapi.types.response.CreateGame;
import com.socialquantum.battleship.gameapi.types.response.DeleteGame;
import com.socialquantum.battleship.gameapi.types.response.DeleteSnapshot;
import com.socialquantum.battleship.gameapi.types.response.GameList;
import com.socialquantum.battleship.gameapi.types.response.GameStatus;
import com.socialquantum.battleship.gameapi.types.response.PlaceShips;
import com.socialquantum.battleship.gameapi.types.response.RestoreSnapshot;
import com.socialquantum.battleship.gameapi.types.response.SaveSnapshot;
import com.socialquantum.battleship.gameapi.types.response.Shoot;
import com.socialquantum.battleship.gameapi.types.response.SnapshotList;
import com.socialquantum.battleship.gameapi.types.response.StartGame;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.Function;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.log4j.Logger;

public class GameConnectionVer1
implements GameConnector {
    private static final Logger LOG = Logger.getLogger(GameConnectionVer1.class);
    private static final String API_TOKEN_HEADER = "apiToken";
    private static final Charset DOCUMENT_CHARSET = Charset.forName("utf-8");
    private static final String GAME_URL_FUNCTION = "/game";
    private final CloseableHttpClient httpclient = HttpClients.createDefault();
    private final String gamefunctions;
    private final UserToken playerTokenId;
    private static final SerializationDeserializationFactory SERIALIZATION_DESERIALIZATION_FACTORY = new SerializationDeserializationFactory();

    private static String loadString(InputStream stream) throws IOException {
        int readBytesCount;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((readBytesCount = stream.read(data)) > 0) {
            byteArrayOutputStream.write(data, 0, readBytesCount);
        }
        return byteArrayOutputStream.toString(DOCUMENT_CHARSET.name());
    }

    public GameConnectionVer1(String host, UserToken playerTokenId) {
        GameUtils.wrapExceptionWoResult(IllegalStateException.class, IllegalStateException::new, () -> new URL(host));
        this.gamefunctions = Objects.requireNonNull(host) + GAME_URL_FUNCTION;
        this.playerTokenId = Objects.requireNonNull(playerTokenId);
    }

    @Override
    public void close() throws IOException {
        GameUtils.wrapExceptionWoResult(IllegalStateException.class, IllegalStateException::new, () -> this.httpclient.close());
    }

    @Override
    public CreateGame createGame(UserToken player1Token, UserToken player2Token) {
        LOG.info((Object)"createGame");
        CreateGameRequestData createGameDataObject = new CreateGameRequestData().setUsers(player1Token, player2Token);
        OperationResult<CreateGameResponseData, DefaultResponse> post = this.post(createGameDataObject, CreateGameResponseData.class, DefaultResponse.class);
        switch (post.result()) {
            case SUCCESS: {
                return post.successData();
            }
            case ERROR: {
                LOG.error((Object)("interaction error " + post.errorData()));
                throw new OperationFailed("interaction error " + post.errorData());
            }
        }
        throw new IllegalStateException("unknown result " + (Object)((Object)post.result()));
    }

    @Override
    public StartGame startGame(GameId gameId) {
        LOG.info((Object)"startGame");
        StartGameRequestData createGameDataObject = new StartGameRequestData().setGameId(gameId);
        OperationResult<StartGameResponseData, DefaultResponse> post = this.post(createGameDataObject, StartGameResponseData.class, DefaultResponse.class);
        switch (post.result()) {
            case SUCCESS: {
                return post.successData();
            }
            case ERROR: {
                LOG.error((Object)("interaction error " + post.errorData()));
                throw new OperationFailed("interaction error " + post.errorData());
            }
        }
        throw new IllegalStateException("unknown result " + (Object)((Object)post.result()));
    }

    @Override
    public DeleteGame deleteGame(GameId gameId) {
        LOG.info((Object)"deleteGame");
        Objects.requireNonNull(gameId);
        DeleteGameRequestData deleteGame = new DeleteGameRequestData().setGameId(gameId);
        OperationResult<DeleteGameResponseData, DefaultResponse> post = this.post(deleteGame, DeleteGameResponseData.class, DefaultResponse.class);
        switch (post.result()) {
            case SUCCESS: {
                return post.successData();
            }
            case ERROR: {
                LOG.error((Object)("interaction error " + post.errorData()));
                throw new OperationFailed("interaction error " + post.errorData());
            }
        }
        throw new IllegalStateException("unknown result " + (Object)((Object)post.result()));
    }

    @Override
    public GameList gameList() {
        LOG.info((Object)"gameList");
        GameListRequestData deleteGame = new GameListRequestData();
        OperationResult<GameListResponseData, DefaultResponse> post = this.post(deleteGame, GameListResponseData.class, DefaultResponse.class);
        switch (post.result()) {
            case SUCCESS: {
                return post.successData();
            }
            case ERROR: {
                LOG.error((Object)("interaction error " + post.errorData()));
                throw new OperationFailed("interaction error " + post.errorData());
            }
        }
        throw new IllegalStateException("unknown result " + (Object)((Object)post.result()));
    }

    @Override
    public GameStatus gameStatus(GameId gameId) {
        LOG.info((Object)"gameStatus");
        GameStatusRequestData statusRequestData = new GameStatusRequestData().setGameId(gameId);
        OperationResult<GameStatusResponseData, DefaultResponse> post = this.post(statusRequestData, GameStatusResponseData.class, DefaultResponse.class);
        switch (post.result()) {
            case SUCCESS: {
                return post.successData();
            }
            case ERROR: {
                LOG.error((Object)("interaction error " + post.errorData()));
                throw new OperationFailed("interaction error " + post.errorData());
            }
        }
        throw new IllegalStateException("unknown result " + (Object)((Object)post.result()));
    }

    @Override
    public PlaceShips placeShips(ShipsPlacementRequest shipsPlacement) {
        LOG.info((Object)"placeShips");
        Objects.requireNonNull(shipsPlacement);
        OperationResult<PlaceShipsResponseData, DefaultResponse> post = this.post(shipsPlacement, PlaceShipsResponseData.class, DefaultResponse.class);
        switch (post.result()) {
            case SUCCESS: {
                return post.successData();
            }
            case ERROR: {
                LOG.error((Object)("interaction error " + post.errorData()));
                throw new OperationFailed("interaction error " + post.errorData());
            }
        }
        throw new IllegalStateException("unknown result " + (Object)((Object)post.result()));
    }

    @Override
    public Shoot shoot(GameId gameId, int x, int y) {
        LOG.info((Object)"shoot");
        Objects.requireNonNull(gameId);
        ShootRequestData makeMoveRequestData = new ShootRequestData().setCoords(x, y).setGameId(gameId);
        OperationResult<ShootResponseData, DefaultResponse> post = this.post(makeMoveRequestData, ShootResponseData.class, DefaultResponse.class);
        switch (post.result()) {
            case SUCCESS: {
                return post.successData();
            }
            case ERROR: {
                LOG.error((Object)("interaction error " + post.errorData()));
                throw new OperationFailed("interaction error " + post.errorData());
            }
        }
        throw new IllegalStateException("unknown result " + (Object)((Object)post.result()));
    }

    @Override
    public SaveSnapshot saveSnapshoot(GameId gameId) {
        LOG.info((Object)"saveSnapshoot ");
        SaveSnapshotRequestData makeMoveRequestData = new SaveSnapshotRequestData().setGameId(gameId);
        OperationResult<SaveSnapshotResponseData, DefaultResponse> post = this.post(makeMoveRequestData, SaveSnapshotResponseData.class, DefaultResponse.class);
        switch (post.result()) {
            case SUCCESS: {
                return post.successData();
            }
            case ERROR: {
                LOG.error((Object)("interaction error " + post.errorData()));
                throw new OperationFailed("interaction error " + post.errorData());
            }
        }
        throw new IllegalStateException("unknown result " + (Object)((Object)post.result()));
    }

    @Override
    public RestoreSnapshot restoreSnapshot(SnapshotId snapshotId) {
        LOG.info((Object)"restoreSnapshot ");
        RestoreSnapshotRequestData requestData = new RestoreSnapshotRequestData().setSnapshotId(snapshotId);
        OperationResult<RestoreSnapshotResponseData, DefaultResponse> post = this.post(requestData, RestoreSnapshotResponseData.class, DefaultResponse.class);
        switch (post.result()) {
            case SUCCESS: {
                return post.successData();
            }
            case ERROR: {
                LOG.error((Object)("interaction error " + post.errorData()));
                throw new OperationFailed("interaction error " + post.errorData());
            }
        }
        throw new IllegalStateException("unknown result " + (Object)((Object)post.result()));
    }

    @Override
    public SnapshotList snapshotList() {
        LOG.info((Object)"snapshotList ");
        SnapshotListRequestData makeMoveRequestData = new SnapshotListRequestData();
        OperationResult<SnapshotListResponseData, DefaultResponse> post = this.post(makeMoveRequestData, SnapshotListResponseData.class, DefaultResponse.class);
        switch (post.result()) {
            case SUCCESS: {
                return post.successData();
            }
            case ERROR: {
                LOG.error((Object)("interaction error " + post.errorData()));
                throw new OperationFailed("interaction error " + post.errorData());
            }
        }
        throw new IllegalStateException("unknown result " + (Object)((Object)post.result()));
    }

    @Override
    public DeleteSnapshot deleteSnapshot(SnapshotId snapshotId) {
        LOG.info((Object)"deleteSnapshot ");
        DeleteSnapshotRequestData requestData = new DeleteSnapshotRequestData().setSnapshotId(snapshotId);
        OperationResult<DeleteSnapshotResponseData, DefaultResponse> post = this.post(requestData, DeleteSnapshotResponseData.class, DefaultResponse.class);
        switch (post.result()) {
            case SUCCESS: {
                return post.successData();
            }
            case ERROR: {
                LOG.error((Object)("interaction error " + post.errorData()));
                throw new OperationFailed("interaction error " + post.errorData());
            }
        }
        throw new IllegalStateException("unknown result " + (Object)((Object)post.result()));
    }

    private <RQ, SuccessResponse, ErrorResponse> OperationResult<SuccessResponse, ErrorResponse> post(RQ requestData, Class<SuccessResponse> successResponseType, Class<ErrorResponse> errorResponseType) {
        Objects.requireNonNull(requestData);
        Objects.requireNonNull(successResponseType);
        Objects.requireNonNull(errorResponseType);
        HttpPost request = new HttpPost(this.gamefunctions);
        request.addHeader(API_TOKEN_HEADER, this.playerTokenId.value());
        String requestString = SERIALIZATION_DESERIALIZATION_FACTORY.saveObject(requestData);
        LOG.info((Object)("request \r\n" + requestString));
        request.setEntity((HttpEntity)new StringEntity(requestString, DOCUMENT_CHARSET));
        return GameUtils.wrapException(OperationException.class, OperationException::new, () -> (OperationResult)this.httpclient.execute((HttpUriRequest)request, new GeneralResponseHandler(successResponseType, errorResponseType)));
    }

    private <RQ, SuccessResponse, ErrorResponse> OperationResult<SuccessResponse, ErrorResponse> post(RQ requestData, Function<String, ResultData<SuccessResponse, ErrorResponse>> handler) {
        Objects.requireNonNull(requestData);
        Objects.requireNonNull(handler);
        HttpPost request = new HttpPost(this.gamefunctions);
        request.addHeader(API_TOKEN_HEADER, this.playerTokenId.value());
        String requestString = SERIALIZATION_DESERIALIZATION_FACTORY.saveObject(requestData);
        LOG.info((Object)("request \r\n" + requestString));
        request.setEntity((HttpEntity)new StringEntity(requestString, DOCUMENT_CHARSET));
        return GameUtils.wrapException(OperationException.class, OperationException::new, () -> (OperationResult)this.httpclient.execute((HttpUriRequest)request, new CustomDataResponseHandler(handler)));
    }

    private static OperationResult.Result recodeStatus(ExecutionStatus executionStatus) {
        switch (executionStatus) {
            case OK: {
                return OperationResult.Result.SUCCESS;
            }
            case ERROR: {
                return OperationResult.Result.ERROR;
            }
        }
        throw new IllegalStateException();
    }

    private static class GeneralResponseHandler<SuccessType, ErrorType>
    implements ResponseHandler<OperationResult<SuccessType, ErrorType>> {
        private final Class<SuccessType> successResultDataClass;
        private final Class<ErrorType> errorResultDataClass;

        private GeneralResponseHandler(Class<SuccessType> successResultDataClass, Class<ErrorType> errorResultDataClass) {
            this.successResultDataClass = Objects.requireNonNull(successResultDataClass);
            this.errorResultDataClass = Objects.requireNonNull(errorResultDataClass);
        }

        public OperationResult<SuccessType, ErrorType> handleResponse(HttpResponse response) throws IOException {
            Throwable throwable = null;
            try (InputStream stream = response.getEntity().getContent();){
                String dataAsString = GameConnectionVer1.loadString(stream);
                int httpResponseCode = response.getStatusLine().getStatusCode();
                LOG.info((Object)("\r\nresponse status " + httpResponseCode + "\r\nresponse body \r\n " + dataAsString));
                switch (SERIALIZATION_DESERIALIZATION_FACTORY.loadObject(dataAsString, DefaultResponse.class).status()) {
                    case ERROR: {
                        OperationResult<Object, ErrorType> operationResult = GameUtils.result(httpResponseCode, OperationResult.Result.ERROR, null, SERIALIZATION_DESERIALIZATION_FACTORY.loadObject(dataAsString, this.errorResultDataClass));
                        return operationResult;
                    }
                    case OK: {
                        OperationResult<SuccessType, Object> operationResult = GameUtils.result(httpResponseCode, OperationResult.Result.SUCCESS, SERIALIZATION_DESERIALIZATION_FACTORY.loadObject(dataAsString, this.successResultDataClass), null);
                        return operationResult;
                    }
                }
                try {
                    throw new IllegalStateException();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private static class CustomDataResponseHandler<SuccessType, ErrorType>
    implements ResponseHandler<OperationResult<SuccessType, ErrorType>> {
        private final Function<String, ResultData<SuccessType, ErrorType>> handlerFunction;

        private CustomDataResponseHandler(Function<String, ResultData<SuccessType, ErrorType>> handlerFunction) {
            this.handlerFunction = Objects.requireNonNull(handlerFunction);
        }

        public OperationResult<SuccessType, ErrorType> handleResponse(HttpResponse response) throws IOException {
            try (InputStream stream = response.getEntity().getContent();){
                String dataAsString = GameConnectionVer1.loadString(stream);
                int httpResponseCode = response.getStatusLine().getStatusCode();
                LOG.info((Object)("\r\nresponse status " + httpResponseCode + "\r\nresponse body \r\n " + dataAsString));
                ResultData<SuccessType, ErrorType> result = this.handlerFunction.apply(dataAsString);
                OperationResult<SuccessType, ErrorType> operationResult = GameUtils.result(httpResponseCode, GameConnectionVer1.recodeStatus(result.status()), result.success(), result.error());
                return operationResult;
            }
        }
    }

    private static class DefaultResultData<SuccessType, ErrorType>
    implements ResultData<SuccessType, ErrorType> {
        private final ExecutionStatus executionStatus;
        private final SuccessType success;
        private final ErrorType error;

        private DefaultResultData(ExecutionStatus executionStatus, SuccessType success, ErrorType error) {
            this.executionStatus = Objects.requireNonNull(executionStatus);
            switch (executionStatus) {
                case OK: {
                    Objects.requireNonNull(success);
                    break;
                }
                case ERROR: {
                    Objects.requireNonNull(error);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.success = success;
            this.error = error;
        }

        @Override
        public SuccessType success() {
            return this.success;
        }

        @Override
        public ErrorType error() {
            return this.error;
        }

        @Override
        public ExecutionStatus status() {
            return this.executionStatus;
        }
    }

    private static interface ResultData<SuccessType, ErrorType> {
        public SuccessType success();

        public ErrorType error();

        public ExecutionStatus status();
    }
}

