/*
 * Decompiled with CFR 0.152.
 */
package com.socialquantum.battleship.gameapi.internal.serializationutils;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus.GameStateDataStatus;
import com.socialquantum.battleship.gameapi.types.base.GameId;
import com.socialquantum.battleship.gameapi.types.base.SnapshotId;
import com.socialquantum.battleship.gameapi.types.base.UserToken;
import com.socialquantum.battleship.gameapi.utils.TransformUtils;
import java.lang.reflect.Type;
import java.util.Objects;

public class SerializationDeserializationFactory {
    private static final GsonBuilder GSON_BUILDER = SerializationDeserializationFactory.configBuilder();

    public <T> T loadObject(String data, Class<T> clazz) {
        return (T)GSON_BUILDER.create().fromJson(data, clazz);
    }

    public String saveObject(Object dataObject) {
        Objects.requireNonNull(dataObject);
        return GSON_BUILDER.create().toJson(dataObject);
    }

    private static GsonBuilder configBuilder() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(GameStateDataStatus.class, (Object)new GameStateDataStatusAdapter());
        gsonBuilder.registerTypeAdapter(GameId.class, (Object)new GameIdAdapter());
        gsonBuilder.registerTypeAdapter(UserToken.class, (Object)new UserTokenAdapter());
        gsonBuilder.registerTypeAdapter(SnapshotId.class, (Object)new SnapshotIdAdapter());
        return gsonBuilder;
    }

    private static class SnapshotIdAdapter
    implements JsonSerializer<SnapshotId>,
    JsonDeserializer<SnapshotId> {
        private SnapshotIdAdapter() {
        }

        public SnapshotId deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return TransformUtils.snapshotId(json.getAsString());
        }

        public JsonElement serialize(SnapshotId src, Type typeOfSrc, JsonSerializationContext context) {
            return src == null ? null : new JsonPrimitive(src.value());
        }
    }

    private static class UserTokenAdapter
    implements JsonSerializer<UserToken>,
    JsonDeserializer<UserToken> {
        private UserTokenAdapter() {
        }

        public UserToken deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return TransformUtils.userToken(json.getAsString());
        }

        public JsonElement serialize(UserToken src, Type typeOfSrc, JsonSerializationContext context) {
            return src == null ? null : new JsonPrimitive(src.value());
        }
    }

    private static class GameIdAdapter
    implements JsonSerializer<GameId>,
    JsonDeserializer<GameId> {
        private GameIdAdapter() {
        }

        public GameId deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return TransformUtils.gameId(json.getAsString());
        }

        public JsonElement serialize(GameId src, Type typeOfSrc, JsonSerializationContext context) {
            return src == null ? null : new JsonPrimitive(src.value());
        }
    }

    private static class GameStateDataStatusAdapter
    implements JsonSerializer<GameStateDataStatus>,
    JsonDeserializer<GameStateDataStatus> {
        private GameStateDataStatusAdapter() {
        }

        public JsonElement serialize(GameStateDataStatus src, Type typeOfSrc, JsonSerializationContext context) {
            if (src == null) {
                return null;
            }
            return new JsonPrimitive(src.ident());
        }

        public GameStateDataStatus deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return GameStateDataStatus.elementByName(json.getAsString());
        }
    }
}

