/*
 * Decompiled with CFR 0.152.
 */
package com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus;

import com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus.DefaultCell;
import com.socialquantum.battleship.gameapi.types.base.BattleField;
import com.socialquantum.battleship.gameapi.types.base.Cell;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class DefaultField
implements BattleField {
    public final List<List<DefaultCell>> cells = new ArrayList<List<DefaultCell>>();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultField)) {
            return false;
        }
        DefaultField field = (DefaultField)o;
        return this.cells.equals(field.cells);
    }

    public void rows(Consumer<DefaultCell[]> consumer) {
        this.cells.forEach(cells -> consumer.accept(cells.toArray(new DefaultCell[cells.size()])));
    }

    public Cell cell(int x, int y) {
        DefaultField.checkIntBounds(0, 9, x);
        DefaultField.checkIntBounds(0, 9, y);
        return this.cells.get(y).get(x);
    }

    public int hashCode() {
        return this.cells.hashCode();
    }

    public static void checkIntBounds(int from, int to, int value) {
        if (from > value || value > to) {
            throw new IllegalArgumentException("value " + value + " is not in bounds [" + from + ", " + to + "]");
        }
    }
}

