/*
 * Decompiled with CFR 0.152.
 */
package com.socialquantum.battleship.gameapi.example;

import com.socialquantum.battleship.gameapi.example.ExampleSettings;
import com.socialquantum.battleship.gameapi.types.base.ShipOrientation;
import com.socialquantum.battleship.gameapi.types.base.ShipType;
import com.socialquantum.battleship.gameapi.types.connector.GameConnector;
import com.socialquantum.battleship.gameapi.types.request.placeships.ShipsPlacementRequest;
import com.socialquantum.battleship.gameapi.types.response.CreateGame;
import com.socialquantum.battleship.gameapi.types.response.DeleteGame;
import com.socialquantum.battleship.gameapi.types.response.DeleteSnapshot;
import com.socialquantum.battleship.gameapi.types.response.GameList;
import com.socialquantum.battleship.gameapi.types.response.GameStatus;
import com.socialquantum.battleship.gameapi.types.response.PlaceShips;
import com.socialquantum.battleship.gameapi.types.response.RestoreSnapshot;
import com.socialquantum.battleship.gameapi.types.response.SaveSnapshot;
import com.socialquantum.battleship.gameapi.types.response.SnapshotList;
import com.socialquantum.battleship.gameapi.utils.ApiConnectionFactory;
import java.io.IOException;

public class Example {
    public static void main(String[] args) throws IOException {
        try (GameConnector connector = ApiConnectionFactory.\u0441onnector("http://93.191.23.197:8080", ExampleSettings.USER_TOKEN);){
            CreateGame game = GameConnector.cast(connector.createGame(ExampleSettings.USER_TOKEN, ExampleSettings.AI_USER_TOKEN_ID), CreateGame.class);
            PlaceShips placeShips = GameConnector.cast(connector.placeShips(ShipsPlacementRequest.createRequest().setGameId(game.gameId()).addShip(ShipType.s2, ShipOrientation.h, 0, 0).addShip(ShipType.s2, ShipOrientation.h, 0, 2).addShip(ShipType.s2, ShipOrientation.h, 0, 3).addShip(ShipType.s2, ShipOrientation.h, 0, 4).addShip(ShipType.s2, ShipOrientation.h, 0, 5)), PlaceShips.class);
            placeShips.message();
            connector.startGame(game.gameId());
            connector.shoot(game.gameId(), 0, 0);
            connector.shoot(game.gameId(), 9, 9);
            GameStatus status = GameConnector.cast(connector.gameStatus(game.gameId()), GameStatus.class);
            status.asset(ExampleSettings.USER_TOKEN);
            status.turnNumber();
            status.currentTurnUserToken();
            SaveSnapshot snapshot = GameConnector.cast(connector.saveSnapshoot(game.gameId()), SaveSnapshot.class);
            GameConnector.cast(connector.snapshotList(), SnapshotList.class).snapshots();
            RestoreSnapshot restoreSnapshot = GameConnector.cast(connector.restoreSnapshot(snapshot.snapshotId()), RestoreSnapshot.class);
            GameConnector.cast(connector.deleteSnapshot(snapshot.snapshotId()), DeleteSnapshot.class);
            GameConnector.cast(connector.gameList(), GameList.class).gameIds();
            DeleteGame deleteGame = GameConnector.cast(connector.deleteGame(game.gameId()), DeleteGame.class);
        }
    }
}

