package com.socialquantum.battleship.gameapi.utils;

import com.socialquantum.battleship.gameapi.types.base.SnapshotId;
import com.socialquantum.battleship.gameapi.types.base.UserToken;
import com.socialquantum.battleship.gameapi.types.base.GameId;

import java.util.Objects;

/**
 * Created 29/06/17 08:38
 *
 * @author Vladimir Bogodukhov
 **/
public class TransformUtils {

    private static class DefaultData implements UserToken, GameId, SnapshotId {
        private final String value;

        public DefaultData(String value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public String value() {
            return value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (!(o instanceof DefaultData)) return false;

            DefaultData that = (DefaultData) o;

            return value != null ? value.equals(that.value) : that.value == null;
        }

        @Override
        public int hashCode() {
            return value != null ? value.hashCode() : 0;
        }

        @Override
        public String toString() {
            return "data(" + "value='" + value + "')";
        }
    }

    /**
     * Преобразование строки в {@link GameId}
     *
     * @param gameId строка с данными
     * @return объект данных
     */
    public static GameId gameId(String gameId) {
        return gameId != null ? new DefaultData(gameId) : null;
    }

    /**
     * Преобразование строки в {@link UserToken}
     *
     * @param tokenData строка с данными
     * @return объект данных
     */
    public static UserToken userToken(String tokenData) {
        return tokenData != null ? new DefaultData(tokenData) : null;
    }

    /**
     * Преобразование строки в {@link SnapshotId}
     *
     * @param snapshotIdData строка с данными
     * @return объект данных
     */
    public static SnapshotId snapshotId(String snapshotIdData) {
        return snapshotIdData != null ? new DefaultData(snapshotIdData) :  null;
    }
}
