package com.socialquantum.battleship.gameapi.types.base;

import java.util.function.Consumer;
import java.util.stream.Stream;

/**
 * Данные пользователя в игре.
 * <p>
 * Created 11/07/17 09:12
 *
 * @author Vladimir Bogodukhov
 *         {@link com.socialquantum.battleship.gameapi.types.base.Asset}
 **/
public interface Asset {

    /**
     * @return Пользователь, которому принадлежат данные (всегда не null)
     */
    UserToken userToken();

    /**
     * Получить статус поля
     *
     * @param x - координата х
     * @param y - координата y
     * @return статус поля (всегда не null)
     */
    CellStatus cellStatus(int x, int y);

    /**
     * Фабрика перечислителей
     * @return Фабрика перечислителей (Всегда не null)
     */
    Iterable<CellEntry> cells();

    /**
     * Возвращает новый поток с элементами {@link CellEntry}
     * @return новый поток с элементами {@link CellEntry}(Всегда не null)
     */
    Stream<CellEntry> cellsStream();


    /**
     * Выдает построчно все клетки игры начиная от 0 до 9 ряда
     *
     * @param consumer потребитель
     */
    void rows(Consumer<Cell[]> consumer);
}
