package com.socialquantum.battleship.gameapi.internal.dataobjects.savesnapshot;

import com.socialquantum.battleship.gameapi.types.base.SnapshotId;
import com.socialquantum.battleship.gameapi.types.base.ExecutionStatus;
import com.socialquantum.battleship.gameapi.types.response.SaveSnapshot;

/**
 *
 * // {
 * //     "status" : "OK",
 * //     "data" : {
 * //         "message" : "Snapshot ef99831b-dec5-4ed6-af4e-c81c9d3b0101 for game ef99831b-dec5-4ed6-af4e-c81c9d3b0102 saved",
 * //         "snapshot_id" : "ef99831b-dec5-4ed6-af4e-c81c9d3b0101"
 * //     }
 * // }
 * Created 06/07/17 15:00
 *
 * @author Vladimir Bogodukhov
 **/
public class SaveSnapshotResponseData implements SaveSnapshot {

    private static class Data {
        private String message;
        private SnapshotId snapshot_id;
    }

    private ExecutionStatus status;
    private final Data data = new Data();

    public ExecutionStatus status() {
        return status;
    }

    public String message() {
        return data.message;
    }

    public SnapshotId snapshotId() {
        return data.snapshot_id;
    }

}
