package com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus;

import com.socialquantum.battleship.gameapi.types.base.CellEntry;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;

/**
 * Created 29/08/17 18:20
 *
 * @author Vladimir Bogodukhov 
 **/
public class CellEntrySpliterator implements Spliterator<CellEntry> {

    private final Iterator<CellEntry> iterator;

    public CellEntrySpliterator(Iterator<CellEntry> iterator) {
        this.iterator = Objects.requireNonNull(iterator);
    }

    @Override
    public boolean tryAdvance(Consumer<? super CellEntry> action) {
        if (!iterator.hasNext()) return false;
        action.accept(iterator.next());
        return true;
    }

    @Override
    public Spliterator<CellEntry> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return NONNULL | IMMUTABLE;
    }
}
