package com.socialquantum.battleship.gameapi.example;

import com.socialquantum.battleship.gameapi.types.base.ShipOrientation;
import com.socialquantum.battleship.gameapi.types.base.ShipType;
import com.socialquantum.battleship.gameapi.types.connector.GameConnector;
import com.socialquantum.battleship.gameapi.types.request.placeships.ShipsPlacementRequest;
import com.socialquantum.battleship.gameapi.types.response.*;
import com.socialquantum.battleship.gameapi.utils.ApiConnectionFactory;

import java.io.IOException;

import static com.socialquantum.battleship.gameapi.example.ExampleSettings.*;
import static com.socialquantum.battleship.gameapi.types.connector.GameConnector.cast;

/**
 * Пример использования методов библиотеки.
 * Показаны основные методы библиотеки связи с игрой.
 * Настройки представлены только для наглядности и не обязательно содержат актуальные данные на момент просмотра.
 *
 *
 * Дополнительно :
 * {@link com.socialquantum.battleship.gameapi.logging.LogSetupExample} Пример содержимого файла настроек log4j
 *
 * {@link com.socialquantum.battleship.gameapi.example.Example2} Пример использования API
 *
 * @author Vladimir Bogodukhov
 * {@link com.socialquantum.battleship.gameapi.example.Example }
 * com.socialquantum.battleship.gameapi.example.Example
 * Created 12/07/17 16:11
 **/
public class Example {

    public static void main(String[] args) throws IOException {

        try (GameConnector connector = ApiConnectionFactory.сonnector(SERVER_HOST, USER_TOKEN)) { /* Создали объект соединения */
            /* Создали игру */
            CreateGame game = cast(connector.createGame(USER_TOKEN, AI_USER_TOKEN_ID), CreateGame.class);

            /* Расставили корабли */
            PlaceShips placeShips = cast(connector.placeShips(
                    ShipsPlacementRequest.createRequest().
                            setGameId(game.gameId()).
                            addShip(ShipType.s2, ShipOrientation.h, 0, 0).
                            addShip(ShipType.s2, ShipOrientation.h, 0, 2).
                            addShip(ShipType.s2, ShipOrientation.h, 0, 3).
                            /* ...... */
                            /* ...... */
                            /* Расставить все корабли */
                            /* ...... */
                            /* ...... */
                                    addShip(ShipType.s2, ShipOrientation.h, 0, 4).
                            addShip(ShipType.s2, ShipOrientation.h, 0, 5)),
                    PlaceShips.class);

            placeShips.message(); /* что-то сделали с сообщением */


            connector.startGame(game.gameId()); /* Начали игру */

            connector.shoot(game.gameId(), 0, 0); /* выстрел */
            connector.shoot(game.gameId(), 9, 9); /* выстрел */

            /* получили статус игры */
            GameStatus status = cast(connector.gameStatus(game.gameId()), GameStatus.class);

            /* работаем со статусом */
            status.asset(USER_TOKEN);
            status.turnNumber();
            /* .... */
            /* .... */
            /* .... */
            status.currentTurnUserToken();

            /* Сохранили состояние игры */
            SaveSnapshot snapshot = cast(connector.saveSnapshoot(game.gameId()), SaveSnapshot.class);


            cast(connector.snapshotList(), SnapshotList.class).snapshots(); /* Получили список всех сохраненных состояний */

            /* Восстановили состояние игры */
            RestoreSnapshot restoreSnapshot = cast(connector.restoreSnapshot(snapshot.snapshotId()), RestoreSnapshot.class);

            /* Удалили состояние игры если больше не требуется */
            cast(connector.deleteSnapshot(snapshot.snapshotId()), DeleteSnapshot.class);

            /* Получили список всех игр для игрока */
            cast(connector.gameList(), GameList.class).gameIds();

            /* Удалили игру - лучше делать в секции finally - чтобы операция выполнялась всегда */
            DeleteGame deleteGame = cast(connector.deleteGame(game.gameId()), DeleteGame.class);


            /*
            Запись типа  cast(connector.snapshotList(), SnapshotList.class); предполагает,
            что мы ожидаем нормального выполнения команды - результат приводится к DeleteGame -
            В том случае если команда выполняется неуспешно - в месте вызова будет ошибка.

            Если требуется дополнительно анализировать результат выполнения можно применить следущую технику:
            OperationResponse response = connector.snapshotList();
            switch (response.status()) {
                case OK:
                    cast(response, SnapshotList.class).snapshots(); // что то делаем со списком
                    break;

                case ERROR:
                    cast(response, OperationError.class).message(); // что то делаем с сообщением об ошибке
                    break;

                default:
                    throw new IllegalStateException("unknown result code");
            }
            */
        }
    }
}
