package com.socialquantum.battleship.gameapi.internal.dataobjects.placeships;

import com.socialquantum.battleship.gameapi.types.base.ShipOrientation;
import com.socialquantum.battleship.gameapi.types.base.ShipType;
import com.socialquantum.battleship.gameapi.types.base.GameId;
import com.socialquantum.battleship.gameapi.types.request.placeships.ShipsPlacementRequest;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

/**
 * // {
 * //     "command": "place_ships",
 * //     "params": {
 * //         "game_id": "37812032-d0fe-42bc-a264-fd271e629c3c",
 * //         "placement_method": "fleet",
 * //         "ships": <[ship_data]>
 * //     }
 * // }
 * Created 29/06/17 09:43
 *
 * @author Vladimir Bogodukhov
 **/
public class PlaceShipsRequestData implements ShipsPlacementRequest {


    private static class Params {
        private GameId game_id;
        private PlacementMethods placement_method = PlacementMethods.fleet;
        private List<Ship> ships = new ArrayList<>();
    }


    private static final String PLACE_SHIPS_COMMAND_NAME = "place_ships";
    private final String command = PLACE_SHIPS_COMMAND_NAME;
    private final Params params = new Params();

    public PlaceShipsRequestData setGameId(GameId gameId) {
        params.game_id = gameId;
        return this;
    }

    public PlaceShipsRequestData addShip(Consumer<Ship> shipConsumer) {
        Ship ship = new Ship();
        shipConsumer.accept(ship);
        params.ships.add(ship);
        return this;
    }

    public PlaceShipsRequestData addShip(ShipType type, ShipOrientation orientation, int x, int y) {
        Ship ship = new Ship();
        ship.params(type, orientation, x, y);
        params.ships.add(ship);
        return this;
    }

    public PlaceShipsRequestData nope() {
        return this;
    }


}
