package com.socialquantum.battleship.gameapi.utils;

import com.socialquantum.battleship.gameapi.internal.connector.GameConnectionVer1;
import com.socialquantum.battleship.gameapi.types.base.UserToken;
import com.socialquantum.battleship.gameapi.types.connector.GameConnector;

/**
 * Фабрика объектов соединений с игрой.
 * Created 10/07/17 12:54
 *
 * @author Vladimir Bogodukhov
 *         {@link com.socialquantum.battleship.gameapi.utils.ApiConnectionFactory}
 **/
public class ApiConnectionFactory {

    /**
     * Получить объект соединения с игрой.
     * Метод создает новый объект соединения с игрой.
     * Полученный объект непотокобезопасный и предполагается использовать один объект на один
     * програмный поток(thread)
     *
     * @param host          - Полное имя хоста к которому производится соединение.  (пример http://somehostname:8082)
     * @param playerTokenId идентификаторо пользователя от имени которого производятся операции.
     * @return Новый объект соединения с игрой
     */
    public static GameConnector сonnector(String host, UserToken playerTokenId) {
        return new GameConnectionVer1(host, playerTokenId);
    }

}
