/*
 * Decompiled with CFR 0.152.
 */
package com.socialquantum.battleship.gameapi.internal.utils;

import com.socialquantum.battleship.gameapi.internal.types.DefaultOperationResult;
import com.socialquantum.battleship.gameapi.internal.types.OperationResult;
import java.util.Objects;
import java.util.function.Function;

public class GameUtils {
    public static <S, E> OperationResult<S, E> result(int code, OperationResult.Result result, S successData, E errorData) {
        return new DefaultOperationResult<S, E>(code, result, successData, errorData);
    }

    public static <R, X extends Throwable> R wrapException(Class<X> excClass, Function<Throwable, X> excProvider, FunctionThatThrows<R> function) throws X {
        Objects.requireNonNull(function);
        Objects.requireNonNull(excProvider);
        try {
            return function.execute();
        }
        catch (Throwable t) {
            throw (Throwable)excProvider.apply(t);
        }
    }

    public static <T, X extends Throwable> void wrapExceptionWoResult(Class<X> excClass, Function<Throwable, X> excProvider, FunctionThatThrowsWoResult<T> function) throws X {
        Objects.requireNonNull(function);
        Objects.requireNonNull(excProvider);
        try {
            function.execute();
        }
        catch (Throwable t) {
            throw (Throwable)excProvider.apply(t);
        }
    }

    @FunctionalInterface
    public static interface FunctionThatThrowsWoResult<T> {
        public void execute() throws Throwable;
    }

    @FunctionalInterface
    public static interface FunctionThatThrows<T> {
        public T execute() throws Throwable;
    }
}

