package com.socialquantum.battleship.gameapi.internal.dataobjects.defaultresponse;

import com.socialquantum.battleship.gameapi.types.base.ExecutionStatus;
import com.socialquantum.battleship.gameapi.types.response.OperationResponse;
import com.socialquantum.battleship.gameapi.types.response.OperationError;

/**
 * // {
 * //     "status": "OK", ("OK", "ERROR")
 * // }
 * Created 29/06/17 18:18
 *
 * @author Vladimir Bogodukhov
 **/
public class DefaultResponse implements OperationResponse, OperationError {

    protected static class Data {
        public String message;

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (!(o instanceof Data)) return false;

            Data data = (Data) o;

            return message != null ? message.equals(data.message) : data.message == null;
        }

        @Override
        public int hashCode() {
            return message != null ? message.hashCode() : 0;
        }

        @Override
        public String toString() {
            return "Data(" + "message='" + message + ")";
        }
    }

    public ExecutionStatus status;
    protected final Data data = new Data();

    public String message() {
        return data.message;
    }

    @Override
    public ExecutionStatus status() {
        return status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DefaultResponse)) return false;

        DefaultResponse that = (DefaultResponse) o;

        return status == that.status;
    }

    @Override
    public int hashCode() {
        return status != null ? status.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "DefaultResponse(" + "status=" + status + ")";
    }
}
