package com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus;

import com.socialquantum.battleship.gameapi.types.base.UserToken;
import com.socialquantum.battleship.gameapi.types.response.GameStatus;
import com.socialquantum.battleship.gameapi.types.base.ExecutionStatus;
import com.socialquantum.battleship.gameapi.utils.TransformUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * Created 30/06/17 09:02
 *
 * @author Vladimir Bogodukhov
 **/
public class GameStatusResponseData implements GameStatus {

    private static class Data {
        private class State {
            private final Map<String, PlayerAsset> assets = new HashMap<>();
            private final List<String> usersOrder = new ArrayList<>();
            private String currentTurnUserToken;
            private int turnNumber;

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (!(o instanceof State)) return false;

                State state = (State) o;

                if (turnNumber != state.turnNumber) return false;
                if (!assets.equals(state.assets)) return false;
                if (!usersOrder.equals(state.usersOrder)) return false;
                return currentTurnUserToken != null ? currentTurnUserToken.equals(state.currentTurnUserToken) : state.currentTurnUserToken == null;
            }

            @Override
            public int hashCode() {
                int result = assets.hashCode();
                result = 31 * result + usersOrder.hashCode();
                result = 31 * result + (currentTurnUserToken != null ? currentTurnUserToken.hashCode() : 0);
                result = 31 * result + turnNumber;
                return result;
            }
        }

        private String game_id;
        private State state = new State();
        private GameStateDataStatus status;

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (!(o instanceof Data)) return false;

            Data data = (Data) o;

            if (game_id != null ? !game_id.equals(data.game_id) : data.game_id != null) return false;
            if (state != null ? !state.equals(data.state) : data.state != null) return false;
            return status == data.status;
        }

        @Override
        public int hashCode() {
            int result = game_id != null ? game_id.hashCode() : 0;
            result = 31 * result + (state != null ? state.hashCode() : 0);
            result = 31 * result + (status != null ? status.hashCode() : 0);
            return result;
        }
    }


    private ExecutionStatus status;
    private final Data data = new Data();

/* --------------------------------------- Реализация API для интерфейса GameStatus --------------------------------  */

    public List<UserToken> usersOrder() {
        return Collections.unmodifiableList(data.state.usersOrder.stream().map(TransformUtils::userToken).collect(Collectors.toList()));
    }

    public ExecutionStatus status() {
        return status;
    }

    public UserToken currentTurnUserToken() {
        return TransformUtils.userToken(data.state.currentTurnUserToken);
    }

    public int turnNumber() {
        return data.state.turnNumber;
    }


    public PlayerAsset asset(UserToken playerToken) {
        return data.state.assets.computeIfAbsent(playerToken.value(), asset -> {
            throw new IllegalStateException("asset " + asset + " not found ");
        });
    }

    public GameStateDataStatus dataStatus() {
        return data.status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof GameStatusResponseData)) return false;

        GameStatusResponseData that = (GameStatusResponseData) o;

        if (status != that.status) return false;
        return data.equals(that.data);
    }

    @Override
    public int hashCode() {
        int result = status != null ? status.hashCode() : 0;
        result = 31 * result + data.hashCode();
        return result;
    }


}
