/*
 * Decompiled with CFR 0.152.
 */
package com.socialquantum.battleship.gameapi.internal.dataobjects.placeships;

import com.socialquantum.battleship.gameapi.internal.dataobjects.placeships.PlacementMethods;
import com.socialquantum.battleship.gameapi.internal.dataobjects.placeships.Ship;
import com.socialquantum.battleship.gameapi.types.base.GameId;
import com.socialquantum.battleship.gameapi.types.base.ShipOrientation;
import com.socialquantum.battleship.gameapi.types.base.ShipType;
import com.socialquantum.battleship.gameapi.types.request.placeships.ShipsPlacementRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class PlaceShipsRequestData
implements ShipsPlacementRequest {
    private static final String PLACE_SHIPS_COMMAND_NAME = "place_ships";
    private final String command = "place_ships";
    private final Params params = new Params();

    @Override
    public PlaceShipsRequestData setGameId(GameId gameId) {
        this.params.game_id = gameId.value();
        return this;
    }

    public PlaceShipsRequestData addShip(Consumer<Ship> shipConsumer) {
        Ship ship = new Ship();
        shipConsumer.accept(ship);
        this.params.ships.add(ship);
        return this;
    }

    @Override
    public PlaceShipsRequestData addShip(ShipType type, ShipOrientation orientation, int x, int y) {
        Ship ship = new Ship();
        ship.params(type, orientation, x, y);
        this.params.ships.add(ship);
        return this;
    }

    public PlaceShipsRequestData nope() {
        return this;
    }

    private static class Params {
        private String game_id;
        private PlacementMethods placement_method = PlacementMethods.fleet;
        private List<Ship> ships = new ArrayList<Ship>();

        private Params() {
        }
    }
}

