(ns smx.eventstore.search.state
  (:import [org.joda.time Period])
  (:require [com.stuartsierra.component :as component]
            [clojure.string :as str]
            [clojure.tools.logging :refer [info error]]))


(def ^:priv ^:const default-plan-node-cost 100000)

(defn cql-ize [k]
  (keyword (str/replace (name k) \- \_)))

(defn get-index-cf [from index]
  (cql-ize (str (name from) "_" (name index) "_idx")))

;TEMP HACK currently this loads index stats by index not index-cf hence above dupe nastiness
(defn load-stats [model cassandra]
  (let [indexes (:indexes model)
          ;; todo yeah i know.. but i dont have plural support
        indexes (replace {:recipients :recipient} indexes)]
    {:default-plan-node-cost default-plan-node-cost
     :tables                 {[:msg_summary] {:rel_tuples 2000 :avg_width 300}}
     :indexes                (into {} (for [i (range (count indexes))] ;cheating to prefer index order as per model
                                        (let [index (nth indexes i)]
                                          [[(get-index-cf :msg_summary index)] {:rel_tuples        2000
                                                                                :null_frac         0.0
                                                                                :avg_width         (* 10 i)
                                                                                :histogram         {}
                                                                                :n_distinct        0.9
                                                                                :most_common_vals  []
                                                                                :most_common_freqs []
                                                                                :histo_bounds      []}])))}))

(defn default-bin-period [] (Period/days 1))

(defn reload-stats [this]
  (assoc this :stats (load-stats (:model this) (:cassandra this))))


(defrecord State [cassandra model]
  component/Lifecycle
  (start [this]
    (info "Starting state component")
    (reload-stats this))

  (stop [this]
    (info "Stopping state component")
    this))

(defn new-state [] (map->State {}))

(defn get-table-stats [this table]
  (get (-> this :stats :tables) [table]))

(defn get-index-stats [this index-cf]

  (get (-> this :stats :indexes) [index-cf]))



