(ns smx.eventstore.search.nrepl
  (:require [clojure.tools.logging :refer [info error]]
            [com.stuartsierra.component :as component]
            [clojure.tools.nrepl.server :as nrs]))

(defrecord Nrepl [port]
  component/Lifecycle
  (start [this]
    (info "Starting nrepl on" port)
    (assoc this :server (nrs/start-server :port port)))

  (stop [this]
    (info "Stopping nrepl")
    (if (:server this) (nrs/stop-server (:server this)))
    this))

(defn new-repl [port]
  (map->Nrepl {:port port}))
