(ns smx.eventstore.search.log
  (:require [clojure.tools.logging :as log]
            [clojure.pprint :as pprint]))

; Auto log search-id if present as expected else barf, I think this is OK
; todo fix repetition

; todo Having second thoughts on this .. perhaps we should just pass context around


(defn pp-str [& things]
  (let [s (with-out-str (pprint/pprint things))]
    (-> s
        (.substring 0 (-> s .length dec dec))
        (str "\n"))))

(defmacro trace [& args]
  `(binding [*print-length* 10]
     (if (instance? Throwable ~(first args))
       (clojure.tools.logging/trace ~(first args) ~'search-id ~@(rest args))
       (clojure.tools.logging/trace ~'search-id ~@args))))

(defmacro debug [& args]
  `(binding [*print-length* 10]
     (if (instance? Throwable ~(first args))
       (clojure.tools.logging/debug ~(first args) ~'search-id ~@(rest args))
       (clojure.tools.logging/debug ~'search-id ~@args))))

(defmacro info [& args]
  `(binding [*print-length* 10]
     (if (instance? Throwable ~(first args))
       (clojure.tools.logging/info ~(first args) ~'search-id ~@(rest args))
       (clojure.tools.logging/info ~'search-id ~@args))))

(defmacro pprint [& args]
  `(binding [*print-length* 10]
     (if (instance? Throwable ~(first args))
       (clojure.tools.logging/info  ~'search-id "\n" ~@(map pp-str (rest args)))
       (clojure.tools.logging/info  ~'search-id "\n" ~@(map pp-str args)))))

(defmacro warn [& args]
  `(binding [*print-length* 10]
     (if (instance? Throwable ~(first args))
       (clojure.tools.logging/warn ~(first args) ~'search-id ~@(rest args))
       (clojure.tools.logging/warn ~'search-id ~@args))))


(defmacro error [& args]
  `(binding [*print-length* 10]
     (if (instance? Throwable ~(first args))
       (clojure.tools.logging/error ~(first args) ~'search-id ~@(rest args))
       (clojure.tools.logging/error ~'search-id ~@args))))
