(ns smx.eventstore.search.dsl
  (:require [instaparse.core :as insta]
            [instaparse.failure :as fail]
            [clojure.string :as str]
            [clojure.java.io :as io]
            [clojure.tools.logging :as log]
            [instaparse.failure :as insta-fail]
            [instaparse.transform :as insta-trans]))

;TODO move to model
(def default-search-fields [:subject :sender :recipients])
(def dsl-fields {"ip"        :sender-mta-ip
                 "msgid"     :msg-id
                 "messageid" :msg-id
                 "smxid"     :sid
                 ;"to"    :recipients ?
                 "rcpts"     :recipients
                 "rcpt"      :recipients
                 "recipient" :recipients
                 ;"from " :sender  ?
                 "subj"      :subject})

(def field-ops {:recipients :any
                :subject    :contains})

(def parser (insta/parser
              (slurp (io/resource "dsl.ebnf"))))

(defn ->field [f]
  (or (dsl-fields f) (keyword f)))

(def val-transformer
  {:val (fn [& chs] [:val (apply str chs)])
   :sq-val (fn [& chs] [:val (apply str chs)])
   :dq-val (fn [& chs] [:val (apply str chs)])})

(defn raw-parse [dsl]
  (let [parse-result (parser dsl)]
    (if (insta/failure? parse-result)
      (let [failure (with-out-str (insta-fail/pprint-failure parse-result))]
        (throw (ex-info "Bad search query."
                        {:user-msg (str "Bad search request. " failure)
                         :error    :validation
                         :detail   {:dsl-parse-error failure}})))
      (if (or (not parse-result) (= parse-result ""))
          [:term [:val ""]]
          (insta-trans/transform
            val-transformer
            (rest parse-result))))))

;todo support '()' and explicit :or and :and
(defn parse [dsl]
  (if (or (nil? dsl) (re-matches #"\s*" dsl))
    []
    (let [parsed (raw-parse dsl)
          conds (reduce
                  (fn [wheres term]
                    (let [parts (rest term)
                          raw-field (if (= (ffirst parts) :field) (second (first parts)))
                          val (if raw-field (second (second parts)) (second (first parts)))]
                      (conj wheres
                            (if raw-field
                              (let [f (->field raw-field)]
                                [(or (field-ops f) =) f val])
                              (into [:or]
                                    (for [f default-search-fields]
                                      [(or (field-ops f) =) f val]))))))
                  [] parsed)]
      (if (empty? conds)
        conds
        (if (= (count conds) 1)                             ;remove superflous wrapper
          (first conds)
          (into [:and] conds))))))