(defproject com.smxemail/archiving-search "1.1.7-SNAPSHOT"
            :description "Archiving Search"
            :min-lein-version "2.3.0"
            :source-paths ["src/clojure"]
            :java-source-paths ["src/java"]
            :test-paths ["test/clojure"]
            :javac-options ["-target" "1.7" "-source" "1.7"]
            :html5-docs-repository-url "git.smxemail.com:dev/eventstore-search.git"
            :html5-docs-ns-includes #"smx.eventstore.search.*"
            :dependencies [[org.clojure/clojure "1.7.0"]
                           [org.clojure/tools.nrepl "0.2.11"]
                           [org.clojure/core.match "0.2.2"]
                           [org.clojure/math.combinatorics "0.1.1"]
                           [com.smxemail/archiving-common "1.0.17"]
                           [com.smxemail/eventstore-cassandra "1.0.13"]
                           [com.smxemail/eventstore-network "2.0.16"]
                           [com.smxemail/smx-lucene "0.1.1"]
                           [fipp "0.6.3"]
                           [instaparse "1.4.1"]
                           [clj-tuple "0.2.2"] ;fuck you ztellman
                           [defm "0.1.1"]]
            :plugins [[lein-marginalia "0.7.1"]
                      [lein-expectations "0.0.8"]
                      [lein-kibit "0.1.2" :exclusions [org.clojure/tools.cli org.clojure/tools.namespace]]
                      [com.ambrosebs/dynalint "0.1.3"]
                      [lein-dynalint "0.1.4"]
                      [lein-ancient "0.5.4" :exclusions [commons-codec]]
                      [lein-cloverage "1.0.2"]
                      [lein-try "0.4.1"]
                      [lein-exec "0.3.1"]
                      [jonase/eastwood "0.2.1" :exclusions [org.clojure/clojure]]
                      [lein-shell "0.4.0"]]
            :repositories [["releases" {:sign-releases false
                                        :url           "http://build.smx.co.nz:8081/nexus/content/repositories/releases"}]
                           ["snapshots" {:url    "http://build.smx.co.nz:8081/nexus/content/repositories/snapshots"
                                         :update :always}]]
            :profiles {:dev   {:source-paths   ["dev"]
                               :resource-paths ["test/resources"]
                               :jvm-opts       ["-XX:MaxPermSize=384m" "-Dconfig.dir=test/config"
                                                "-XX:-OmitStackTraceInFastThrow" "-Dlog.dir=target/logs"]
                               :dependencies   [[expectations "2.1.2" :exclusions [joda-time com.google.guava/guava org.clojure/tools.reader com.google.protobuf/protobuf-java]]
                                                [org.clojure/test.check "0.8.2"]
                                                [org.clojure/tools.namespace "0.2.10"]
                                                [alembic "0.3.2"]
                                                ;[rhizome "0.2.5"] ;instaparse viz
                                                [org.clojure/java.classpath "0.2.2"]
                                                [com.climate/java.shell2 "0.1.0"]
                                                [org.clojure/tools.trace "0.7.9"]
                                                [clj-http "1.1.2" :exclusions [com.fasterxml.jackson.dataformat/jackson-dataformat-smile com.fasterxml.jackson.core/jackson-annotations clj-tuple com.fasterxml.jackson.core/jackson-databind com.fasterxml.jackson.core/jackson-core cheshire]]
                                                [com.smxemail/ccm-clj "1.1.0-SNAPSHOT" :exclusions [org.clojure/tools.logging]]]}
                       :perf  [:dev {:jvm-opts     ["-Xmx2g" "-XX:MaxPermSize=384m"]
                                     :dependencies [[criterium "0.4.3"]]}]
                       :debug [:dev {:debug      true
                                     :injections [(prn (into {} (System/getProperties)))]
                                     :jvm-opts   ["-XX:MaxPermSize=384m"
                                     "-XX:-OmitStackTraceInFastThrow" "-Xmx2g" "-server"
                                     "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=5005"]}]}
            :repl-options {:init-ns user}
            :main nil
            :manifest {"Main-Class" "smx.eventstore.search.Main"}
            :release-tasks [["shell" "git" "flow" "release" "start" "lein-release"]
                            ["vcs" "assert-committed"]
                            ["change" "version"
                             "leiningen.release/bump-version" "release"]
                            ["vcs" "commit"]
                            ["vcs" "tag"]
                            ["smx" "deploy" ":uberjar" ":jar"]
                            ["shell" "git" "flow" "release" "finish" "--notag" "--push"]
                            ["change" "version" "leiningen.release/bump-version"]
                            ["vcs" "commit"] `["vcs" "push"]])
