(ns com.sixsq.nuvla.server.resources.spec.vulnerability-test
  (:require
    [clojure.test :refer [deftest]]
    [com.sixsq.nuvla.server.resources.spec.spec-test-utils :as stu]
    [com.sixsq.nuvla.server.resources.spec.vulnerability :as vulnerability]
    [com.sixsq.nuvla.server.resources.vulnerability :as t]))


(def valid-acl {:owners   ["group/nuvla-admin"]
                :edit-acl ["group/nuvla-admin"]})


(deftest check-vulnerability-schema
  (let [timestamp     "1964-08-25T10:00:00.00Z"
        vulnerability {:id            (str t/resource-type "/abcdef")
                       :name          "my vulnerability"
                       :description   "description of my vulnerability"
                       :reference     "https://url/threat?id=1"
                       :score         4.6
                       :severity      "MEDIUM"
                       :published     "1964-08-25T10:00:00.00Z"
                       :modified      "1964-08-25T10:00:00.00Z"
                       :resource-type t/resource-type
                       :created       timestamp
                       :updated       timestamp
                       :acl           valid-acl
                       }]

    (stu/is-valid ::vulnerability/schema vulnerability)

    (stu/is-invalid ::vulnerability/schema (assoc vulnerability :bad "value"))

    (doseq [attr #{:id :resource-type :created :updated :acl}]
      (stu/is-invalid ::vulnerability/schema (dissoc vulnerability attr)))

    (doseq [attr #{:name :description :reference :score :severity :published :modified}]
      (stu/is-valid ::vulnerability/schema (dissoc vulnerability attr)))))
