

(ns signal.data-platform-telemetry.histogram-buckets
  (:require [clojure.string :as string]
            [signal.data-platform-telemetry.metrics :as metrics]))

(defn generate-pipeline-histogram-buckets
  "Generate buckets for the pipeline document latency histogram.

   This function should be used in the REPL to generate latency histogram buckets
   "
  ([{:keys [target-slo
            low-resolution-step
            high-resolution-step
            max-bucket-value
            exponential-factor]
     :or {target-slo 90
          low-resolution-step 15
          high-resolution-step 5
          max-bucket-value (* 180 60)
          exponential-factor 1.2}}]
   (let [high-resolution-floor (/ target-slo 2)
         high-resolution-ceiling (+ target-slo (/ target-slo 2))
         low-resolution-for-low-values (range 0 high-resolution-floor low-resolution-step)
         high-resolution-around-slo (range high-resolution-floor high-resolution-ceiling high-resolution-step)
         exponential-for-high-values (rest (metrics/exponential-buckets (last high-resolution-around-slo) exponential-factor max-bucket-value))
         document-latency-buckets (concat low-resolution-for-low-values
                                          high-resolution-around-slo
                                          exponential-for-high-values)]
     (->> document-latency-buckets
          (map #(format "%.1f" (double %)))
          (string/join ","))))
  ([]
   (generate-pipeline-histogram-buckets {})))

(comment
  (generate-pipeline-histogram-buckets))
