(defproject com.signal-ai/data-platform-telemetry "0.4.10-SNAPSHOT"
  :description "Data Platform Telemetry"
  :url "http://github.com/signal-ai/data-platform-telemetry"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :dependencies [[org.clojure/clojure "1.11.1" :scope "provided"]
                 [io.prometheus/simpleclient_hotspot "0.15.0"]
                 [clj-commons/iapetos "0.1.12" :exclusions [io.prometheus/simpleclient]]
                 [clojure.java-time "0.3.3"]
                 [circleci/rollcage "1.0.203"]
                 [org.clojure/tools.logging "1.2.4"]]

  :profiles {:test {:dependencies [[lambdaisland/kaocha "1.66.1034"]
                                   [lambdaisland/kaocha-junit-xml "0.0.76"]
                                   [lambdaisland/kaocha-cloverage "1.0.75"]]}}

  :deploy-repositories [["releases" {:url "https://clojars.org/repo"
                                     :username :env/clojars_username
                                     :password :env/clojars_token
                                     :sign-releases false}]
                        ["snapshots" {:url "https://clojars.org/repo"
                                      :username :env/clojars_username
                                      :password :env/clojars_token}]]
  :aliases {"test" ["with-profile" "dev,test" "run" "-m" "kaocha.runner"]})
