# Data Platform Telemetry

Telemetry setup code for Data Platform services.

## Usage

[![Clojars Project](https://img.shields.io/clojars/v/com.signal-ai/data-platform-telemetry.svg)](https://clojars.org/com.signal-ai/data-platform-telemetry)

Include this libary in your `project.clj` (see clojars for the latest version).

```clj
(require '[signal.data_platform_telemetry.metrics :as metrics])

;; initialise a metrics registry
;; the returned registry is an iapetos registry - new metrics can be registered using standard iapetos functions
(def metrics-config {;; optional, can disable JVM metrics
                      jvm? false
                      ;; optional, can disable ring metrics
                      ring? false

                      ;; optional, can be set to 1 or increased if non-standard
                      :max-batch-size 50
                      ;; optional, can be increased from the default maximum of 2 seconds if required
                      :max-expected-stage-time-seconds 4
                      ;; optional, can be increased from the default maximum of 16 seconds if required
                      :max-expected-result-time-seconds 32

                      ;; required for pipeline-queue-latency
                      :document-latency-buckets [0.1 0.25 0.5 1 2 4 8 16 32 64]})

(def registry (-> (metrics/init metrics-config)
                 (metrics/pipeline-queue-reader metrics-config)
                 (metrics/pipeline-queue-writer metrics-config)
                 (metrics/pipeline-queue-latency metrics-config)))

;; increment a metric
(metrics/observe-message-total-time registry (System/currentTimeMillis))
```

## License

Copyright © 2022 Signal AI

This program and the accompanying materials are made available under the
terms of the Eclipse Public License 2.0 which is available at
http://www.eclipse.org/legal/epl-2.0.

This Source Code may also be made available under the following Secondary
Licenses when the conditions for such availability set forth in the Eclipse
Public License, v. 2.0 are satisfied: GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or (at your
option) any later version, with the GNU Classpath Exception which is available
at https://www.gnu.org/software/classpath/license.html.
