/*
 * Decompiled with CFR 0.152.
 */
package com.shopstyle.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.shopstyle.api.BrandListResponse;
import com.shopstyle.api.CategoryListResponse;
import com.shopstyle.api.ColorListResponse;
import com.shopstyle.api.FavoriteListResponse;
import com.shopstyle.api.PageRequest;
import com.shopstyle.api.ProductHistogramResponse;
import com.shopstyle.api.ProductQuery;
import com.shopstyle.api.ProductSearchResponse;
import com.shopstyle.api.ProductSort;
import com.shopstyle.api.RetailerListResponse;
import com.shopstyle.api.SizeListResponse;
import com.shopstyle.bo.Category;
import com.shopstyle.bo.Product;
import com.shopstyle.bo.User;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.message.BasicNameValuePair;

public class ShopStyle {
    public static final int DEFAULT_VERSION = 2;
    public static final String US_API_HOSTNAME = "api.shopstyle.com";
    public static final String UK_API_HOSTNAME = "api.shopstyle.co.uk";
    public static final String DE_API_HOSTNAME = "api.shopstyle.de";
    public static final String FR_API_HOSTNAME = "api.shopstyle.fr";
    public static final String JP_API_HOSTNAME = "api.shopstyle.co.jp";
    public static final String AU_API_HOSTNAME = "api.shopstyle.com.au";
    public static final String CA_API_HOSTNAME = "api.shopstyle.ca";
    public static final String[] ALL_LOCALES = new String[]{"all"};
    protected static final Charset UTF8Charset = Charset.forName("UTF-8");
    protected static final ContentType JSONContentType = ContentType.APPLICATION_JSON;
    private final String scheme = "http";
    private final String host;
    private int port = 80;
    private final String pathPrefix;
    private final String partnerId;
    private HttpClient httpClient;
    private String[] locales;
    private ObjectMapper mapper;
    private String secretKey;

    public ShopStyle(String partnerId) {
        this(partnerId, US_API_HOSTNAME, 2);
    }

    public ShopStyle(String partnerId, String hostname) {
        this(partnerId, hostname, 2);
    }

    public ShopStyle(String partnerId, String hostname, int version) {
        this.partnerId = partnerId;
        this.host = hostname;
        this.pathPrefix = "/api/v" + version;
        this.configure();
    }

    private void configure() {
        this.httpClient = new DefaultHttpClient();
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void close() {
        if (this.httpClient != null) {
            ClientConnectionManager connectionManager = this.httpClient.getConnectionManager();
            if (connectionManager != null) {
                connectionManager.shutdown();
            }
            this.httpClient = null;
        }
        if (this.mapper != null) {
            this.mapper = null;
        }
    }

    public void setPort(int newPort) {
        if (newPort <= 0) {
            throw new IllegalArgumentException("Invalid port: " + newPort);
        }
        this.port = newPort;
    }

    public void setLocales(String[] locales) {
        if (locales == null || locales.length == 0) {
            this.locales = null;
        }
        this.locales = locales;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public Product getProduct(long productId) throws APIException {
        return this.callGet("/products/" + productId, null, Product.class);
    }

    public ProductSearchResponse getProducts(ProductQuery request) throws APIException {
        return this.getProducts(request, null, null);
    }

    public ProductSearchResponse getProducts(ProductQuery request, PageRequest page) throws APIException {
        return this.getProducts(request, page, null);
    }

    public ProductSearchResponse getProducts(ProductQuery query, PageRequest page, ProductSort sort) throws APIException {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        if (page != null) {
            page.addParameters(parameters);
        }
        if (sort != null && sort != ProductSort.Relevance) {
            parameters.add((NameValuePair)new BasicNameValuePair("sort", sort.name()));
        }
        query.addParameters(parameters);
        return this.callGet("/products", parameters, ProductSearchResponse.class);
    }

    public ProductHistogramResponse getProductsHistogram(ProductQuery query, Class ... filters) throws APIException {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        StringBuilder filtersString = new StringBuilder();
        for (Class filter : filters) {
            if (filtersString.length() > 0) {
                filtersString.append(',');
            }
            filtersString.append(filter.getSimpleName());
        }
        parameters.add((NameValuePair)new BasicNameValuePair("filters", filtersString.toString()));
        query.addParameters(parameters);
        return this.callGet("/products/histogram", parameters, ProductHistogramResponse.class);
    }

    public BrandListResponse getBrands() throws APIException {
        return this.callGet("/brands", null, BrandListResponse.class);
    }

    public CategoryListResponse getCategories(Category root, int depth) throws APIException {
        return this.getCategories(root == null ? null : root.getId(), depth);
    }

    public CategoryListResponse getCategories(String rootId, int depth) throws APIException {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        if (rootId != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("cat", rootId));
        }
        if (depth > 0) {
            parameters.add((NameValuePair)new BasicNameValuePair("depth", String.valueOf(depth)));
        }
        return this.callGet("/categories", parameters, CategoryListResponse.class);
    }

    public ColorListResponse getColors() throws APIException {
        return this.callGet("/colors", null, ColorListResponse.class);
    }

    public RetailerListResponse getRetailers() throws APIException {
        return this.callGet("/retailers", null, RetailerListResponse.class);
    }

    public SizeListResponse getSizes(Category category) throws APIException {
        assert (category != null);
        return this.getSizes(category.getId());
    }

    public SizeListResponse getSizes(String categoryId) throws APIException {
        assert (categoryId != null);
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("cat", categoryId));
        return this.callGet("/sizes", parameters, SizeListResponse.class);
    }

    public User getUser(String userId) throws APIException {
        return this.callGet("/users/" + userId, null, User.class);
    }

    public FavoriteListResponse getFavorites(User user, PageRequest page) throws APIException {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("userId", user.getId()));
        if (page != null) {
            page.addParameters(parameters);
        }
        return this.callGet("/favorites", parameters, FavoriteListResponse.class);
    }

    public void downloadTransactions(Date startDate, Date endDate, File destination) throws APIException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("start", dateFormat.format(startDate)));
        parameters.add((NameValuePair)new BasicNameValuePair("end", dateFormat.format(endDate)));
        this.download("/partner/transactions", parameters, destination);
    }

    protected <T> T callGet(String requestPath, List<NameValuePair> parameters, Class<T> responseType) throws APIException {
        URI uri = this.getCallURI(requestPath, parameters);
        HttpGet get = new HttpGet(uri);
        return this.call((HttpRequestBase)get, responseType);
    }

    protected <T> T secureCallGet(String requestPath, List<NameValuePair> parameters, Class<T> responseType, String userId) throws APIException {
        URI uri = this.getCallURI(requestPath, parameters);
        HttpGet get = new HttpGet(uri);
        this.addSecureHeader((HttpRequestBase)get, userId, null);
        return this.call((HttpRequestBase)get, responseType);
    }

    protected <T> T callPost(String requestPath, List<NameValuePair> queryParameters, Object postDetails, Class<T> responseType) throws APIException {
        URI uri = this.getCallURI(requestPath, queryParameters);
        HttpPost post = new HttpPost(uri);
        this.addJsonEntity((HttpEntityEnclosingRequestBase)post, postDetails);
        return this.call((HttpRequestBase)post, responseType);
    }

    protected <T> T secureCallPost(String requestPath, List<NameValuePair> queryParameters, Object postDetails, Class<T> responseType, String userId) throws APIException {
        URI uri = this.getCallURI(requestPath, queryParameters);
        HttpPost post = new HttpPost(uri);
        String jsonBody = this.addJsonEntity((HttpEntityEnclosingRequestBase)post, postDetails);
        this.addSecureHeader((HttpRequestBase)post, userId, jsonBody);
        return this.call((HttpRequestBase)post, responseType);
    }

    protected <T> T callPut(String requestPath, List<NameValuePair> queryParameters, Object postDetails, Class<T> responseType) throws APIException {
        URI uri = this.getCallURI(requestPath, queryParameters);
        HttpPut put = new HttpPut(uri);
        this.addJsonEntity((HttpEntityEnclosingRequestBase)put, postDetails);
        return this.call((HttpRequestBase)put, responseType);
    }

    protected <T> T secureCallPut(String requestPath, List<NameValuePair> queryParameters, Object postDetails, Class<T> responseType, String userId) throws APIException {
        URI uri = this.getCallURI(requestPath, queryParameters);
        HttpPut put = new HttpPut(uri);
        String jsonBody = this.addJsonEntity((HttpEntityEnclosingRequestBase)put, postDetails);
        this.addSecureHeader((HttpRequestBase)put, userId, jsonBody);
        return this.call((HttpRequestBase)put, responseType);
    }

    protected void secureCallDelete(String requestPath, List<NameValuePair> queryParameters, String userId) throws APIException {
        URI uri = this.getCallURI(requestPath, queryParameters);
        HttpDelete delete = new HttpDelete(uri);
        this.addSecureHeader((HttpRequestBase)delete, userId, null);
        this.call((HttpRequestBase)delete, null);
    }

    private String getAuthorizationToken(String userId, String formattedDate) {
        try {
            MessageDigest hasher = MessageDigest.getInstance("SHA");
            hasher.update(Hex.decodeHex((char[])this.secretKey.toCharArray()));
            hasher.update(this.partnerId.getBytes(UTF8Charset));
            if (userId != null) {
                hasher.update(userId.getBytes(UTF8Charset));
            }
            hasher.update(formattedDate.getBytes(UTF8Charset));
            String token = new String(Base64.encodeBase64((byte[])hasher.digest()));
            if (userId == null) {
                return token;
            }
            return userId + ":" + token;
        }
        catch (NoSuchAlgorithmException exp) {
            throw new RuntimeException(exp);
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    private String addJsonEntity(HttpEntityEnclosingRequestBase request, Object bodyDetails) throws APIException {
        if (bodyDetails != null) {
            String jsonBody;
            try {
                jsonBody = this.mapper.writeValueAsString(bodyDetails);
            }
            catch (JsonProcessingException e) {
                throw new APIException("Unable to serialize the request", e);
            }
            request.setEntity((HttpEntity)new StringEntity(jsonBody, JSONContentType));
            return jsonBody;
        }
        return null;
    }

    protected final URI getCallURI(String requestPath, List<NameValuePair> parameters) throws APIException {
        URI uri;
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme("http").setHost(this.host).setPort(this.port);
        uriBuilder.setPath(this.pathPrefix + requestPath);
        uriBuilder.addParameter("pid", this.partnerId);
        if (this.locales != null) {
            for (String localeName : this.locales) {
                uriBuilder.addParameter("locales", localeName);
            }
        }
        if (parameters != null && !parameters.isEmpty()) {
            for (NameValuePair parameter : parameters) {
                uriBuilder.addParameter(parameter.getName(), parameter.getValue());
            }
        }
        try {
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new APIException("Error while building URI", e);
        }
        return uri;
    }

    protected final <T> T call(HttpRequestBase get, Class<T> responseType) throws APIException {
        HttpResponse response;
        if (this.httpClient == null) {
            throw new IllegalStateException("Client was closed");
        }
        try {
            response = this.httpClient.execute((HttpUriRequest)get);
        }
        catch (Exception e) {
            throw new APIException("Error while executing call to " + get.getURI(), e);
        }
        try {
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode < 200 || responseCode >= 300) {
                HttpEntity errorResponse = response.getEntity();
                JsonNode errorDescription = this.mapper.readTree(errorResponse.getContent());
                JsonNode errorMessage = errorDescription.get("errorMessage");
                if (errorMessage == null || errorMessage.isNull()) {
                    throw new APIException("Undescribed error: " + errorDescription);
                }
                throw new APIException(errorMessage.asText());
            }
            if (responseType != null) {
                HttpEntity successResponse = response.getEntity();
                Object object = this.mapper.readValue(successResponse.getContent(), responseType);
                return (T)object;
            }
            T t = null;
            return t;
        }
        catch (APIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new APIException("Error while processing response", e);
        }
        finally {
            get.releaseConnection();
        }
    }

    protected void download(String requestPath, List<NameValuePair> queryParameters, File destination) throws APIException {
        HttpResponse response;
        File destinationDirectory = destination.getParentFile();
        if (!destinationDirectory.isDirectory()) {
            if (destinationDirectory.exists()) {
                throw new APIException(destinationDirectory + " is not a directory!");
            }
            if (!destinationDirectory.mkdirs()) {
                throw new APIException("Error creating " + destinationDirectory);
            }
        }
        URI uri = this.getCallURI(requestPath, queryParameters);
        HttpGet get = new HttpGet(uri);
        this.addSecureHeader((HttpRequestBase)get, null, null);
        if (this.httpClient == null) {
            throw new IllegalStateException("Client was closed");
        }
        try {
            response = this.httpClient.execute((HttpUriRequest)get);
        }
        catch (Exception e) {
            throw new APIException("Error while executing call to " + get.getURI(), e);
        }
        try {
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode < 200 || responseCode >= 300) {
                HttpEntity errorResponse = response.getEntity();
                JsonNode errorDescription = this.mapper.readTree(errorResponse.getContent());
                JsonNode errorMessage = errorDescription.get("errorMessage");
                if (errorMessage == null || errorMessage.isNull()) {
                    throw new APIException("Undescribed error: " + errorDescription);
                }
                throw new APIException(errorMessage.asText());
            }
            HttpEntity successResponse = response.getEntity();
            IOUtils.copy((InputStream)successResponse.getContent(), (OutputStream)new FileOutputStream(destination));
        }
        catch (APIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new APIException("Error while processing response", e);
        }
        finally {
            get.releaseConnection();
        }
    }

    protected void addSecureHeader(HttpRequestBase request, String userId, String body) {
        if (this.secretKey == null || this.secretKey.length() == 0) {
            throw new IllegalStateException("The secret key must be set!");
        }
        Date requestDate = new Date();
        String formattedDate = DateUtils.formatDate((Date)requestDate);
        request.addHeader("Date", formattedDate);
        String authorizationToken = this.getAuthorizationToken(userId, formattedDate);
        request.addHeader("Authorization", "SHPST " + authorizationToken);
    }

    public static class APIException
    extends Exception {
        public APIException(String message) {
            super(message);
        }

        public APIException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

