/*
 * Decompiled with CFR 0.152.
 */
package com.shopstyle.api;

import com.shopstyle.bo.Category;
import com.shopstyle.bo.SearchFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class ProductQuery {
    private String categoryId;
    private List<String> textSearches = new ArrayList<String>(1);
    private List<String> filters = new ArrayList<String>(3);
    private long priceDropDate;

    public ProductQuery withCategory(Category category) {
        this.categoryId = category != null ? category.getId() : null;
        return this;
    }

    public ProductQuery withCategory(String categoryId) {
        this.categoryId = categoryId != null && categoryId.length() > 0 ? categoryId : null;
        return this;
    }

    public ProductQuery withFreeText(String text) {
        if (text != null && text.length() > 0) {
            this.textSearches.add(text);
        }
        return this;
    }

    public ProductQuery withFilter(SearchFilter filter) {
        if (filter != null) {
            this.filters.add(filter.getFilterId());
        }
        return this;
    }

    public ProductQuery withFilter(String filterId) {
        if (filterId != null & filterId.length() > 0) {
            this.filters.add(filterId);
        }
        return this;
    }

    public ProductQuery withPriceDropDate(Date date) {
        if (date != null) {
            this.priceDropDate = date.getTime();
        }
        return this;
    }

    public ProductQuery withPriceDropDate(long timestamp) {
        if (timestamp > 0L) {
            this.priceDropDate = timestamp;
        }
        return this;
    }

    void addParameters(List<NameValuePair> parameters) {
        if (this.categoryId != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("cat", this.categoryId));
        }
        for (String text : this.textSearches) {
            parameters.add((NameValuePair)new BasicNameValuePair("fts", text));
        }
        for (String filterId : this.filters) {
            parameters.add((NameValuePair)new BasicNameValuePair("fl", filterId));
        }
        if (this.priceDropDate > 0L) {
            parameters.add((NameValuePair)new BasicNameValuePair("fl", "d200"));
            parameters.add((NameValuePair)new BasicNameValuePair("pdd", String.valueOf(this.priceDropDate)));
        }
    }
}

