/*
 * Decompiled with CFR 0.152.
 */
package com.shash.hbase.ds;

import com.shash.hbase.ds.Parametrizable;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public abstract class AbstractRowKeyDistributor
implements Parametrizable {
    public abstract byte[] getDistributedKey(byte[] var1);

    public abstract byte[] getOriginalKey(byte[] var1);

    public abstract byte[][] getAllDistributedKeys(byte[] var1);

    public Pair<byte[], byte[]>[] getDistributedIntervals(byte[] originalStartKey, byte[] originalStopKey) {
        byte[][] stopKeys;
        byte[][] startKeys = this.getAllDistributedKeys(originalStartKey);
        if (Arrays.equals(originalStopKey, HConstants.EMPTY_END_ROW)) {
            Arrays.sort(startKeys, Bytes.BYTES_RAWCOMPARATOR);
            stopKeys = this.getAllDistributedKeys(HConstants.EMPTY_BYTE_ARRAY);
            for (int i = 0; i < stopKeys.length - 1; ++i) {
                stopKeys[i] = stopKeys[i + 1];
            }
            stopKeys[stopKeys.length - 1] = HConstants.EMPTY_END_ROW;
        } else {
            stopKeys = this.getAllDistributedKeys(originalStopKey);
            assert (stopKeys.length == startKeys.length);
        }
        Pair[] intervals = new Pair[startKeys.length];
        for (int i = 0; i < startKeys.length; ++i) {
            intervals[i] = new Pair((Object)startKeys[i], (Object)stopKeys[i]);
        }
        return intervals;
    }

    public final Scan[] getDistributedScans(Scan original) throws IOException {
        Pair<byte[], byte[]>[] intervals = this.getDistributedIntervals(original.getStartRow(), original.getStopRow());
        Scan[] scans = new Scan[intervals.length];
        for (int i = 0; i < intervals.length; ++i) {
            scans[i] = new Scan(original);
            scans[i].setStartRow((byte[])intervals[i].getFirst());
            scans[i].setStopRow((byte[])intervals[i].getSecond());
        }
        return scans;
    }

    public void addInfo(Configuration conf) {
        conf.set("hbase.mapreduce.scan.wd.distributor.class", this.getClass().getCanonicalName());
        String paramsToStore = this.getParamsToStore();
        if (paramsToStore != null) {
            conf.set("hbase.mapreduce.scan.wd.distributor.params", paramsToStore);
        }
    }
}

